/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class ThrowableAssert
extends GenericAssert<ThrowableAssert, Throwable> {
    @VisibleForTesting
    final ObjectAssert objectAssert;

    protected ThrowableAssert(@Nullable Throwable actual) {
        super(ThrowableAssert.class, actual);
        this.objectAssert = new ObjectAssert(actual);
    }

    @Nonnull
    public ThrowableAssert isInstanceOf(@Nonnull Class<? extends Throwable> type) {
        this.objectAssert.isInstanceOf(type);
        return this;
    }

    @Nonnull
    public ThrowableAssert isExactlyInstanceOf(@Nonnull Class<?> type) {
        this.isNotNull();
        Preconditions.checkNotNull(type);
        Class<?> current = ((Throwable)this.actual).getClass();
        if (type.equals(current)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected exactly the same type:<%s> but was:<%s>", type, current));
    }

    @Nonnull
    public ThrowableAssert hasMessage(@Nullable String message) {
        this.isNotNull();
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), ((Throwable)this.actual).getMessage(), message);
        return this;
    }

    @Nonnull
    public ThrowableAssert hasNoCause() {
        this.isNotNull();
        Throwable actualCause = ((Throwable)this.actual).getCause();
        if (actualCause == null) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected exception without cause, but cause was:<%s>", actualCause.getClass()));
    }

    @Override
    @Nonnull
    public ThrowableAssert as(@Nullable String description) {
        this.objectAssert.as(description);
        return (ThrowableAssert)super.as(description);
    }

    @Override
    @Nonnull
    public ThrowableAssert describedAs(@Nullable String description) {
        return this.as(description);
    }

    @Override
    @Nonnull
    public ThrowableAssert as(@Nullable Description description) {
        this.objectAssert.as(description);
        return (ThrowableAssert)super.as(description);
    }

    @Override
    @Nonnull
    public ThrowableAssert describedAs(@Nullable Description description) {
        return this.as(description);
    }

    @Override
    @Nonnull
    public ThrowableAssert overridingErrorMessage(@Nullable String message) {
        this.objectAssert.overridingErrorMessage(message);
        return (ThrowableAssert)super.overridingErrorMessage(message);
    }
}

