/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

public class DoubleAssert
extends GenericAssert<DoubleAssert, Double>
implements NumberAssert {
    private static final double ZERO = 0.0;

    protected DoubleAssert(double actual) {
        super(DoubleAssert.class, actual);
    }

    protected DoubleAssert(@Nullable Double actual) {
        super(DoubleAssert.class, actual);
    }

    @Deprecated
    @Nonnull
    public static Delta delta(double d) {
        return new Delta(d);
    }

    @Override
    @Nonnull
    public DoubleAssert isEqualTo(double expected) {
        return (DoubleAssert)this.isEqualTo(Double.valueOf(expected));
    }

    @Deprecated
    @Nonnull
    public DoubleAssert isEqualTo(double expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    @Nonnull
    public DoubleAssert isEqualTo(double expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.doubleValue());
    }

    @Nonnull
    private DoubleAssert isEqualTo(double expected, double deltaValue) {
        return this.isEqualTo((Double)expected, deltaValue);
    }

    @Nonnull
    public DoubleAssert isEqualTo(@Nullable Double expected, @Nonnull org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.doubleValue());
    }

    @Nonnull
    private DoubleAssert isEqualTo(@Nullable Double expected, double deltaValue) {
        if (this.actual == null || expected == null) {
            return (DoubleAssert)this.isEqualTo(expected);
        }
        if (((Double)this.actual).compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected - (Double)this.actual) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected) + Formatting.format(" using delta:<%s>", deltaValue));
    }

    @Override
    @Nonnull
    public DoubleAssert isNotEqualTo(double other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    @Nonnull
    public DoubleAssert isGreaterThan(double other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public DoubleAssert isLessThan(double other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    @Nonnull
    public DoubleAssert isGreaterThanOrEqualTo(double other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    @Nonnull
    public DoubleAssert isLessThanOrEqualTo(double other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    private int compareTo(double other) {
        return Double.compare((Double)this.actual, other);
    }

    @Override
    @Nonnull
    public DoubleAssert isZero() {
        return this.isEqualTo(0.0);
    }

    @Override
    @Nonnull
    public DoubleAssert isPositive() {
        return this.isGreaterThan(0.0);
    }

    @Override
    @Nonnull
    public DoubleAssert isNegative() {
        return this.isLessThan(0.0);
    }

    @Nonnull
    public DoubleAssert isNaN() {
        return this.isEqualTo(Double.NaN);
    }

    @Deprecated
    public static class Delta {
        final double value;

        private Delta(double value) {
            this.value = value;
        }
    }
}

