/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class CharArrayAssert
extends ArrayAssert<CharArrayAssert, char[]> {
    protected CharArrayAssert(char ... actual) {
        super(CharArrayAssert.class, actual);
    }

    @Nonnull
    public CharArrayAssert contains(char ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public CharArrayAssert containsOnly(char ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public CharArrayAssert excludes(char ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public CharArrayAssert isEqualTo(@Nullable char[] expected) {
        if (Arrays.equals((char[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public CharArrayAssert isNotEqualTo(@Nullable char[] array) {
        if (!Arrays.equals((char[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

