/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.references;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CodeSetupPsiReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiLiteral> ADD_FLOW_LOCATION = CodeSetupPsiReferenceContributor.createPattern("addFlowLocation");
    public static final PsiElementPattern.Capture<PsiLiteral> ADD_FLOW_LOCATION_PATTERN = CodeSetupPsiReferenceContributor.createPattern("addFlowLocationPattern");
    public static final PsiElementPattern.Capture<PsiLiteral> BASE_PATH = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setBasePath")).inClass("org.springframework.webflow.config.FlowDefinitionRegistryBuilder")));

    @NotNull
    private static PsiElementPattern.Capture<PsiLiteral> createPattern(String methodName) {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodName)).inClass("org.springframework.webflow.config.FlowDefinitionRegistryBuilder")));
        if (capture == null) {
            CodeSetupPsiReferenceContributor.$$$reportNull$$$0(0);
        }
        return capture;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            CodeSetupPsiReferenceContributor.$$$reportNull$$$0(1);
        }
        PsiReferenceProvider flowLocationReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text = ElementManipulators.getValueText((PsiElement)element);
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)text).filter(item -> {
                    if (item.isDirectory()) {
                        return true;
                    }
                    PsiFile file = item.getContainingFile();
                    return JamCommonUtil.isPlainXmlFile((PsiElement)file) && WebflowDomModelManager.getInstance(item.getProject()).isWebflow((XmlFile)file);
                }).fromRoot(StringUtil.startsWithChar((CharSequence)text, (char)'/')).customDefaultPathEvaluator(CodeSetupPsiReferenceContributor.createBasePathEvaluator(element));
                PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        registrar.registerReferenceProvider(ADD_FLOW_LOCATION, flowLocationReferenceProvider, 100.0);
        registrar.registerReferenceProvider(ADD_FLOW_LOCATION_PATTERN, flowLocationReferenceProvider, 100.0);
        registrar.registerReferenceProvider(BASE_PATH, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                String text = ElementManipulators.getValueText((PsiElement)element);
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)text).filter(item -> item.isDirectory()).endingSlashNotAllowed(false).fromRoot(StringUtil.startsWithChar((CharSequence)text, (char)'/'));
                PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
    }

    private static Function<PsiFile, Collection<PsiFileSystemItem>> createBasePathEvaluator(@NotNull PsiElement element) {
        if (element == null) {
            CodeSetupPsiReferenceContributor.$$$reportNull$$$0(2);
        }
        return file -> {
            PsiMethod method;
            if (element == null) {
                CodeSetupPsiReferenceContributor.$$$reportNull$$$0(3);
            }
            if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element.getOriginalElement().getParent(), PsiMethod.class)) == null) {
                return null;
            }
            for (PsiLiteral literal : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)method)).filter(PsiLiteral.class)) {
                if (!BASE_PATH.accepts((Object)literal)) continue;
                return SpringResourcesUtil.getInstance().getResourceItems(literal.getReferences(), Conditions.alwaysTrue());
            }
            return null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/references/CodeSetupPsiReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBasePathEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createBasePathEvaluator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

