/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.impl.WebflowDomModelFactory;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.ViewOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDomModelManagerImpl
extends WebflowDomModelManager {
    private final WebflowDomModelFactory myDomModelFactory;
    private final DomManager myDomManager;

    public WebflowDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myDomModelFactory = new WebflowDomModelFactory(project);
    }

    @Override
    public boolean isWebflow(@NotNull XmlFile file) {
        if (file == null) {
            WebflowDomModelManagerImpl.$$$reportNull$$$0(0);
        }
        return this.myDomManager.getFileElement(file, Flow.class) != null;
    }

    @Override
    @Nullable
    public WebflowModel getWebflowModel(@NotNull XmlFile file) {
        if (file == null) {
            WebflowDomModelManagerImpl.$$$reportNull$$$0(1);
        }
        return (WebflowModel)this.myDomModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<WebflowModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            WebflowDomModelManagerImpl.$$$reportNull$$$0(2);
        }
        return this.myDomModelFactory.getAllModels((UserDataHolder)module);
    }

    @Override
    public List<WebflowModel> getModelsForView(@NotNull PsiFile viewFile) {
        Module module;
        if (viewFile == null) {
            WebflowDomModelManagerImpl.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)viewFile)) == null) {
            return Collections.emptyList();
        }
        List<WebflowModel> allModels = this.getAllModels(module);
        return ContainerUtil.filter(allModels, webflowModel -> {
            if (viewFile == null) {
                WebflowDomModelManagerImpl.$$$reportNull$$$0(5);
            }
            Flow flow = webflowModel.getFlow();
            List viewOwners = DomUtil.getDefinedChildrenOfType((DomElement)flow, ViewOwner.class, (boolean)true, (boolean)false);
            return ContainerUtil.exists((Iterable)viewOwners, owner -> {
                if (viewFile == null) {
                    WebflowDomModelManagerImpl.$$$reportNull$$$0(6);
                }
                return Comparing.equal((Object)owner.getResolvedView(), (Object)viewFile);
            });
        });
    }

    @Override
    public Flow findFlowByName(@NotNull Module module, String name) {
        WebflowModel webflowModel;
        if (module == null) {
            WebflowDomModelManagerImpl.$$$reportNull$$$0(4);
        }
        return (webflowModel = (WebflowModel)ContainerUtil.find(this.getAllModels(module), model -> Comparing.equal((String)model.getName(), (String)name))) != null ? webflowModel.getFlow() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWebflow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebflowModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllModels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelsForView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findFlowByName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getModelsForView$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

