/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditModuleSettingsIntentionAction
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(EditModuleSettingsIntentionAction.class);

    @NotNull
    public String getText() {
        String string = J2MEBundle.message("edit.mobile.module.settings.intention.title", new Object[0]);
        if (string == null) {
            EditModuleSettingsIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            EditModuleSettingsIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            EditModuleSettingsIntentionAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        return MobileModuleUtil.isExecutable(EditModuleSettingsIntentionAction.findClassUnderCursor(editor, file), module);
    }

    @Nullable
    private static PsiClass findClassUnderCursor(Editor editor, PsiFile file) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiClass.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile;
        if (project == null) {
            EditModuleSettingsIntentionAction.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((virtualFile = file.getVirtualFile()) != null);
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        LOG.assertTrue(module != null);
        ProjectSettingsService.getInstance((Project)project).showModuleConfigurationDialog(module.getName(), J2MEBundle.message("mobile.module.settings.title", new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/module/intentions/EditModuleSettingsIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

