/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class J2MEModuleProperties
implements JDOMExternalizable {
    private final Module myModule;
    private String myResourcePath;
    private MobileApplicationType myMobileApplicationType;
    @NonNls
    private static final String RESOURCE = "resourceRoot";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String APPLICATION_TYPE = "mobileApplicationType";
    @NonNls
    private static final String TYPE_NAME = "name";

    public J2MEModuleProperties(Module module) {
        this.myModule = module;
    }

    public static J2MEModuleProperties getInstance(Module module) {
        return ModuleType.is((Module)module, (ModuleType)J2MEModuleType.getInstance()) ? (J2MEModuleProperties)ModuleServiceManager.getService((Module)module, J2MEModuleProperties.class) : null;
    }

    public String getResourcePath() {
        return this.myResourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.myResourcePath = resourcePath;
    }

    @Nullable
    public MobileApplicationType getMobileApplicationType() {
        return this.myMobileApplicationType;
    }

    public void setMobileApplicationType(MobileApplicationType mobileApplicationType) {
        this.myMobileApplicationType = mobileApplicationType;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element type;
        Element resource = element.getChild(RESOURCE);
        if (resource != null) {
            this.myResourcePath = resource.getAttributeValue(PATH);
        }
        if ((type = element.getChild(APPLICATION_TYPE)) != null) {
            String name = type.getAttributeValue(TYPE_NAME);
            this.myMobileApplicationType = MobileModuleUtil.getMobileApplicationTypeByName(name);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myResourcePath != null) {
            Element resource = new Element(RESOURCE);
            resource.setAttribute(PATH, this.myResourcePath);
            element.addContent(resource);
        }
        if (this.myMobileApplicationType != null) {
            Element type = new Element(APPLICATION_TYPE);
            type.setAttribute(TYPE_NAME, this.myMobileApplicationType.getName());
            element.addContent(type);
        }
    }
}

