/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class EjbFileNameMapping {
    @NotNull
    private static String generateFileName(MavenArtifact a, boolean addVersion) {
        String extension = a.getExtension();
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(a.getArtifactId());
        if (addVersion) {
            buffer.append('-').append(a.getBaseVersion());
        }
        if (!StringUtil.isEmpty((String)a.getClassifier())) {
            buffer.append('-').append(a.getClassifier());
        }
        if (!StringUtil.isEmpty((String)extension)) {
            buffer.append('.').append(extension);
        }
        String string = buffer.toString();
        if (string == null) {
            EjbFileNameMapping.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String generateFileName(MavenArtifact a, @Nullable String mappingName) {
        if ("full".equals(mappingName)) {
            String dashedGroupId = a.getGroupId().replace('.', '-');
            String string = dashedGroupId + "-" + EjbFileNameMapping.generateFileName(a, true);
            if (string == null) {
                EjbFileNameMapping.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("no-version".equals(mappingName)) {
            String string = EjbFileNameMapping.generateFileName(a, false);
            if (string == null) {
                EjbFileNameMapping.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("no-version-for-ejb".equals(mappingName)) {
            boolean isEjb = "ejb".equals(a.getType());
            String string = EjbFileNameMapping.generateFileName(a, !isEjb);
            if (string == null) {
                EjbFileNameMapping.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = EjbFileNameMapping.generateFileName(a, true);
        if (string == null) {
            EjbFileNameMapping.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/ext/jee/EjbFileNameMapping", "generateFileName"));
    }
}

