/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.websocket.jam.SpringMessageMapping;
import com.intellij.spring.websocket.jam.SpringMessagingJamModel;
import com.intellij.spring.websocket.jam.SpringMessagingUrlAnnotation;
import com.intellij.spring.websocket.jam.SpringSendTo;
import com.intellij.spring.websocket.jam.SpringSendToUser;
import com.intellij.spring.websocket.model.messaging.SpringMessagingMethodUrlDefinition;
import com.intellij.spring.websocket.model.messaging.SpringMessagingModel;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.SpringMessagingUrlDefinition;
import com.intellij.spring.websocket.model.messaging.SpringWebSocketPrefixes;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UrlCollector
extends NotNullLazyValue<MultiMap<SpringMessagingType, SpringMessagingModel.Variant>> {
    private static final String DEFAULT_DESTINATION_PREFIX = "/topic";
    private static final String SIMP_MESSAGE_SENDING_OPERATIONS = "org.springframework.messaging.simp.SimpMessageSendingOperations";
    private static final String SEND_TO_USER_METHOD = "convertAndSendToUser";
    private static final String SEND_TO_METHOD = "convertAndSend";
    @NotNull
    private final Module myModule;
    private final boolean myIncludeTests;
    private SpringWebSocketPrefixes myPrefixes;

    UrlCollector(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            UrlCollector.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myIncludeTests = includeTests;
    }

    @NotNull
    protected MultiMap<SpringMessagingType, SpringMessagingModel.Variant> compute() {
        this.myPrefixes = new SpringWebSocketPrefixes(this.myModule);
        MultiMap result = new MultiMap();
        ArrayList<SpringMessagingUrlDefinition> urlDefinitions = new ArrayList<SpringMessagingUrlDefinition>();
        SpringMessagingJamModel messagingJamModel = new SpringMessagingJamModel(this.myModule, this.myIncludeTests);
        urlDefinitions.addAll(messagingJamModel.getMessageMappings());
        urlDefinitions.addAll(messagingJamModel.getSubscribeMappings());
        urlDefinitions.addAll(messagingJamModel.getSendTos());
        urlDefinitions.addAll(messagingJamModel.getSendToUsers());
        urlDefinitions.addAll(this.getMethodUrlDefinitions());
        for (SpringMessagingUrlDefinition messagingUrlDefinition : urlDefinitions) {
            SpringMessagingType messagingType = messagingUrlDefinition.getMessagingType();
            if (messagingType == null) continue;
            SpringMessageMapping.ClassMapping classMapping = messagingUrlDefinition.getClassMapping();
            List<UrlPointer> urlPointers = messagingUrlDefinition.getUrlPointers();
            for (UrlPointer urlDefinitionPointer : urlPointers) {
                if (classMapping != null && messagingType.isAffectedByClassAnnotation) {
                    this.processClassMapping((MultiMap<SpringMessagingType, SpringMessagingModel.Variant>)result, messagingUrlDefinition, classMapping, urlDefinitionPointer);
                    continue;
                }
                this.addUrl((MultiMap<SpringMessagingType, SpringMessagingModel.Variant>)result, messagingUrlDefinition, urlDefinitionPointer, null);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            UrlCollector.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    private List<SpringMessagingUrlDefinition> getMethodUrlDefinitions() {
        PsiClass simpClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)SIMP_MESSAGE_SENDING_OPERATIONS);
        if (simpClass == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)this.myIncludeTests);
        SmartList result = new SmartList();
        UrlCollector.addSendTos((List<SpringMessagingUrlDefinition>)result, searchScope, simpClass, SEND_TO_USER_METHOD, SpringMessagingType.SEND_TO_USER, 1);
        UrlCollector.addSendTos((List<SpringMessagingUrlDefinition>)result, searchScope, simpClass, SEND_TO_METHOD, SpringMessagingType.SEND_TO, 0);
        return result;
    }

    private static void addSendTos(List<SpringMessagingUrlDefinition> result, GlobalSearchScope searchScope, @NotNull PsiClass simpClass, @NotNull String methodName, @NotNull SpringMessagingType messagingType, int destinationParamIndex) {
        PsiMethod[] sendToUsers;
        if (simpClass == null) {
            UrlCollector.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            UrlCollector.$$$reportNull$$$0(3);
        }
        if (messagingType == null) {
            UrlCollector.$$$reportNull$$$0(4);
        }
        for (PsiMethod sendToUser : sendToUsers = simpClass.findMethodsByName(methodName, true)) {
            PsiParameter[] parameters = sendToUser.getParameterList().getParameters();
            if (parameters.length < destinationParamIndex + 2) continue;
            MethodReferencesSearch.search((PsiMethod)sendToUser, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                PsiMethodCallExpression methodCallExpression;
                if (messagingType == null) {
                    UrlCollector.$$$reportNull$$$0(12);
                }
                if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class)) != null) {
                    PsiExpression destinationArgument = methodCallExpression.getArgumentList().getExpressions()[destinationParamIndex];
                    result.add(new SpringMessagingMethodUrlDefinition(messagingType, (PsiElement)destinationArgument, StringUtil.unquoteString((String)destinationArgument.getText())));
                }
                return true;
            });
        }
    }

    private void addUrl(@NotNull MultiMap<SpringMessagingType, SpringMessagingModel.Variant> result, @NotNull SpringMessagingUrlDefinition messagingUrlDefinition, @NotNull UrlPointer urlDefinition, @Nullable UrlPointer classPrefix) {
        SpringMessagingType messagingType;
        if (result == null) {
            UrlCollector.$$$reportNull$$$0(5);
        }
        if (messagingUrlDefinition == null) {
            UrlCollector.$$$reportNull$$$0(6);
        }
        if (urlDefinition == null) {
            UrlCollector.$$$reportNull$$$0(7);
        }
        if ((messagingType = messagingUrlDefinition.getMessagingType()) == null) {
            return;
        }
        for (UrlPointer prefix : this.myPrefixes.get(messagingType)) {
            result.putValue((Object)messagingType, (Object)new SpringMessagingModel.Variant(prefix, classPrefix, urlDefinition));
        }
        if (messagingUrlDefinition instanceof SpringMessageMapping.MethodMapping) {
            SpringMessageMapping.MethodMapping methodMapping = (SpringMessageMapping.MethodMapping)messagingUrlDefinition;
            SpringMessagingUrlAnnotation sendTo = (SpringMessagingUrlAnnotation)JamService.getJamService((Project)this.myModule.getProject()).getJamElement(methodMapping.getPsiElement(), new JamMemberMeta[]{SpringSendTo.META, SpringSendToUser.META});
            if (sendTo == null) {
                result.putValue((Object)SpringMessagingType.SEND_TO, (Object)new SpringMessagingModel.Variant(new UrlPointer(null, DEFAULT_DESTINATION_PREFIX), classPrefix, urlDefinition));
            }
        }
    }

    private void processClassMapping(@NotNull MultiMap<SpringMessagingType, SpringMessagingModel.Variant> result, @NotNull SpringMessagingUrlDefinition messagingUrlDefinition, @NotNull SpringMessageMapping.ClassMapping classMapping, @NotNull UrlPointer urlDefinition) {
        if (result == null) {
            UrlCollector.$$$reportNull$$$0(8);
        }
        if (messagingUrlDefinition == null) {
            UrlCollector.$$$reportNull$$$0(9);
        }
        if (classMapping == null) {
            UrlCollector.$$$reportNull$$$0(10);
        }
        if (urlDefinition == null) {
            UrlCollector.$$$reportNull$$$0(11);
        }
        if (classMapping.getUrls().isEmpty()) {
            this.addUrl(result, messagingUrlDefinition, urlDefinition, null);
        } else {
            for (JamStringAttributeElement<String> classUrl : classMapping.getUrls()) {
                this.addUrl(result, messagingUrlDefinition, urlDefinition, new UrlPointer(classUrl));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/websocket/model/messaging/UrlCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagingType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagingUrlDefinition";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDefinition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/websocket/model/messaging/UrlCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSendTos";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addUrl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processClassMapping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSendTos$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

