/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHelper {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHelper.class);

    private GitUntrackedFilesHelper() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(final @NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, final @NotNull String operation, @Nullable String description) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(1);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(2);
        }
        if (operation == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(3);
        }
        String notificationTitle = StringUtil.capitalize((String)operation) + " failed";
        String notificationDesc = description == null ? GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operation, true) : description;
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, notificationDesc, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String dialogDesc = GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operation, false);
                    String title = "Untracked Files Preventing " + StringUtil.capitalize((String)operation);
                    if (untrackedFiles.isEmpty()) {
                        GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                    } else {
                        UntrackedFilesDialog dialog = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                        dialog.setTitle(title);
                        dialog.show();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "git4idea/util/GitUntrackedFilesHelper$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static String createUntrackedFilesOverwrittenDescription(@NotNull String operation, boolean addLinkToViewFiles) {
        if (operation == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(4);
        }
        String description1 = " untracked working tree files would be overwritten by " + operation + ".";
        String description2 = "Please move or remove them before you can " + operation + ".";
        String notificationDesc = addLinkToViewFiles ? "Some" + description1 + "<br/>" + description2 + " <a href='view'>View them</a>" : "These" + description1 + "<br/>" + description2;
        String string = notificationDesc;
        if (string == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean showUntrackedFilesDialogWithRollback(@NotNull Project project, @NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(6);
        }
        if (operationName == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(7);
        }
        if (rollbackProposal == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(9);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(10);
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        Ref rollback = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            JComponent filesBrowser;
            if (project == null) {
                GitUntrackedFilesHelper.$$$reportNull$$$0(11);
            }
            if (operationName == null) {
                GitUntrackedFilesHelper.$$$reportNull$$$0(12);
            }
            if (rollbackProposal == null) {
                GitUntrackedFilesHelper.$$$reportNull$$$0(13);
            }
            if (untrackedFiles.isEmpty()) {
                LOG.debug("Couldn't find the untracked files, displaying simplified dialog.");
                filesBrowser = new GitSimplePathsBrowser(project, absolutePaths);
            } else {
                long validFiles = untrackedFiles.stream().filter(VirtualFile::isValid).count();
                LOG.debug(String.format("Untracked files: [%s]. Valid: %d (of %d)", untrackedFiles, validFiles, untrackedFiles.size()));
                filesBrowser = ScrollPaneFactory.createScrollPane((Component)new SelectFilesDialog.VirtualFileList(project, false, true, untrackedFiles));
            }
            String title = "Could not " + StringUtil.capitalize((String)operationName);
            String description = StringUtil.stripHtml((String)GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription(operationName, false), (boolean)true);
            UntrackedFilesRollBackDialog dialog = new UntrackedFilesRollBackDialog(project, filesBrowser, description, rollbackProposal);
            dialog.setTitle(title);
            DialogManager.show(dialog);
            rollback.set((Object)dialog.isOK());
        });
        return (Boolean)rollback.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitUntrackedFilesHelper";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollbackProposal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitUntrackedFilesHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUntrackedFilesOverwrittenDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notifyUntrackedFilesOverwrittenBy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUntrackedFilesOverwrittenDescription";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesDialogWithRollback";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showUntrackedFilesDialogWithRollback$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UntrackedFilesRollBackDialog
    extends DialogWrapper {
        @NotNull
        private final JComponent myFilesBrowser;
        @NotNull
        private final String myPrompt;
        @NotNull
        private final String myRollbackProposal;

        public UntrackedFilesRollBackDialog(@NotNull Project project, @NotNull JComponent filesBrowser, @NotNull String prompt, @NotNull String rollbackProposal) {
            if (project == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(0);
            }
            if (filesBrowser == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(1);
            }
            if (prompt == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(2);
            }
            if (rollbackProposal == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(3);
            }
            super(project);
            this.myFilesBrowser = filesBrowser;
            this.myPrompt = prompt;
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText("Rollback");
            this.setCancelButtonText("Don't rollback");
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            if (buttons != null) {
                panel.add(buttons);
            }
            return panel;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myFilesBrowser;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prompt";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rollbackProposal";
                    break;
                }
            }
            objectArray[1] = "git4idea/util/GitUntrackedFilesHelper$UntrackedFilesRollBackDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        public UntrackedFilesDialog(Project project, Collection<VirtualFile> untrackedFiles, String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, false, true);
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                UntrackedFilesDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitUntrackedFilesHelper$UntrackedFilesDialog", "createActions"));
        }
    }
}

