/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class GitFetchResult {
    private final Type myType;
    private Collection<Exception> myErrors;
    private Collection<String> myPrunedRefs;

    public GitFetchResult(@NotNull Type type) {
        if (type == null) {
            GitFetchResult.$$$reportNull$$$0(0);
        }
        this.myErrors = new ArrayList<Exception>();
        this.myPrunedRefs = new ArrayList<String>();
        this.myType = type;
    }

    @NotNull
    public static GitFetchResult success() {
        GitFetchResult gitFetchResult = new GitFetchResult(Type.SUCCESS);
        if (gitFetchResult == null) {
            GitFetchResult.$$$reportNull$$$0(1);
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult cancel() {
        GitFetchResult gitFetchResult = new GitFetchResult(Type.CANCELLED);
        if (gitFetchResult == null) {
            GitFetchResult.$$$reportNull$$$0(2);
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(Collection<Exception> errors) {
        GitFetchResult result2 = new GitFetchResult(Type.ERROR);
        result2.myErrors = errors;
        GitFetchResult gitFetchResult = result2;
        if (gitFetchResult == null) {
            GitFetchResult.$$$reportNull$$$0(3);
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(Exception error) {
        GitFetchResult gitFetchResult = GitFetchResult.error(Collections.singletonList(error));
        if (gitFetchResult == null) {
            GitFetchResult.$$$reportNull$$$0(4);
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(@NotNull String errorMessage) {
        if (errorMessage == null) {
            GitFetchResult.$$$reportNull$$$0(5);
        }
        GitFetchResult gitFetchResult = GitFetchResult.error(new Exception(errorMessage));
        if (gitFetchResult == null) {
            GitFetchResult.$$$reportNull$$$0(6);
        }
        return gitFetchResult;
    }

    public boolean isSuccess() {
        return this.myType == Type.SUCCESS;
    }

    public boolean isCancelled() {
        return this.myType == Type.CANCELLED;
    }

    public boolean isNotAuthorized() {
        return this.myType == Type.NOT_AUTHORIZED;
    }

    public boolean isError() {
        return this.myType == Type.ERROR;
    }

    @NotNull
    public Collection<? extends Exception> getErrors() {
        Collection<Exception> collection = this.myErrors;
        if (collection == null) {
            GitFetchResult.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public void addPruneInfo(@NotNull Collection<String> prunedRefs) {
        if (prunedRefs == null) {
            GitFetchResult.$$$reportNull$$$0(8);
        }
        this.myPrunedRefs.addAll(prunedRefs);
    }

    @NotNull
    public Collection<String> getPrunedRefs() {
        Collection<String> collection = this.myPrunedRefs;
        if (collection == null) {
            GitFetchResult.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public String getAdditionalInfo() {
        if (!this.myPrunedRefs.isEmpty()) {
            String string = "Pruned obsolete remote " + StringUtil.pluralize((String)"reference", (int)this.myPrunedRefs.size()) + ": " + StringUtil.join(this.myPrunedRefs, (String)", ");
            if (string == null) {
                GitFetchResult.$$$reportNull$$$0(10);
            }
            return string;
        }
        if ("" == null) {
            GitFetchResult.$$$reportNull$$$0(11);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitFetchResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prunedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitFetchResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "success";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cancel";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrunedRefs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPruneInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        SUCCESS,
        CANCELLED,
        NOT_AUTHORIZED,
        ERROR;

    }
}

