/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    private static final Logger LOG = Logger.getInstance(GitRepositoryManager.class);
    public static final Comparator<GitRepository> DEPENDENCY_COMPARATOR = (repo1, repo2) -> -VirtualFileHierarchicalComparator.getInstance().compare(repo1.getRoot(), repo2.getRoot());
    @NotNull
    private final GitVcsSettings mySettings;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    @Deprecated
    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(0);
        }
        if (platformFacade == null) {
            GitRepositoryManager.$$$reportNull$$$0(1);
        }
        if (vcsRepositoryManager == null) {
            GitRepositoryManager.$$$reportNull$$$0(2);
        }
        this(project, vcsRepositoryManager);
    }

    public GitRepositoryManager(@NotNull Project project, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(3);
        }
        if (vcsRepositoryManager == null) {
            GitRepositoryManager.$$$reportNull$$$0(4);
        }
        super(vcsRepositoryManager, (AbstractVcs)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))), ".git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    @NotNull
    public static GitRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(5);
        }
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        if (gitRepositoryManager == null) {
            GitRepositoryManager.$$$reportNull$$$0(6);
        }
        return gitRepositoryManager;
    }

    public boolean isSyncEnabled() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new GitMultiRootBranchConfig(this.getRepositories()).diverged();
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list = this.getRepositories(GitRepository.class);
        if (list == null) {
            GitRepositoryManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }

    @NotNull
    public Collection<GitRepository> getDirectSubmodules(@NotNull GitRepository superProject) {
        if (superProject == null) {
            GitRepositoryManager.$$$reportNull$$$0(8);
        }
        Collection<GitSubmoduleInfo> modules = superProject.getSubmodules();
        List list = ContainerUtil.mapNotNull(modules, module -> {
            VirtualFile submoduleDir;
            if (superProject == null) {
                GitRepositoryManager.$$$reportNull$$$0(12);
            }
            if ((submoduleDir = superProject.getRoot().findFileByRelativePath(module.getPath())) == null) {
                LOG.debug("submodule dir not found at declared path [" + module.getPath() + "] of root [" + superProject.getRoot() + "]");
                return null;
            }
            GitRepository repository = (GitRepository)this.getRepositoryForRoot(submoduleDir);
            if (repository == null) {
                LOG.warn("Submodule not registered as a repository: " + submoduleDir);
            }
            return repository;
        });
        if (list == null) {
            GitRepositoryManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<GitRepository> sortByDependency(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRepositoryManager.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.sorted(repositories, DEPENDENCY_COMPARATOR);
        if (list == null) {
            GitRepositoryManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformFacade";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRepositoryManager";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superProject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectSubmodules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDirectSubmodules";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sortByDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDirectSubmodules$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

