/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean mySuccess;
    private final int myExitCode;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    @Nullable
    private final Throwable myException;

    public GitCommandResult(boolean success, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable Throwable exception) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(0);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(1);
        }
        this.myExitCode = exitCode;
        this.mySuccess = success;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myException = exception;
    }

    @NotNull
    public static GitCommandResult merge(@Nullable GitCommandResult first, @NotNull GitCommandResult second) {
        if (second == null) {
            GitCommandResult.$$$reportNull$$$0(2);
        }
        if (first == null) {
            GitCommandResult gitCommandResult = second;
            if (gitCommandResult == null) {
                GitCommandResult.$$$reportNull$$$0(3);
            }
            return gitCommandResult;
        }
        int mergedExitCode = first.myExitCode == 0 ? second.myExitCode : (second.myExitCode == 0 ? first.myExitCode : second.myExitCode);
        GitCommandResult gitCommandResult = new GitCommandResult(first.success() && second.success(), mergedExitCode, ContainerUtil.concat(first.myErrorOutput, second.myErrorOutput), ContainerUtil.concat(first.myOutput, second.myOutput), (Throwable)ObjectUtils.chooseNotNull((Object)second.myException, (Object)first.myException));
        if (gitCommandResult == null) {
            GitCommandResult.$$$reportNull$$$0(4);
        }
        return gitCommandResult;
    }

    public boolean success() {
        return this.mySuccess;
    }

    @NotNull
    public List<String> getOutput() {
        List<String> list = Collections.unmodifiableList(this.myOutput);
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(5);
        }
        return list;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @NotNull
    public List<String> getErrorOutput() {
        List<String> list = Collections.unmodifiableList(this.myErrorOutput);
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(6);
        }
        return list;
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"<br/>");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private List<String> getErrorOrStdOutput() {
        List<String> list = this.myErrorOutput.isEmpty() && !this.success() ? this.myOutput : this.myErrorOutput;
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        String string = StringUtil.join(this.myOutput, (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public Throwable getException() {
        return this.myException;
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        if (error == null) {
            GitCommandResult.$$$reportNull$$$0(11);
        }
        GitCommandResult gitCommandResult = new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList(), null);
        if (gitCommandResult == null) {
            GitCommandResult.$$$reportNull$$$0(12);
        }
        return gitCommandResult;
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(13);
        }
        List list = ContainerUtil.map(errorOutput, errorMessage -> GitUtil.cleanupErrorPrefixes(errorMessage));
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsHtmlString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsJoinedString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOrStdOutput";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputAsJoinedString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

