/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateStaticMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.integration.model.xml.core.SpelFunction;
import com.intellij.spring.integration.util.SimpleMethodSignature;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.Nullable;

public class SpelFunctionMethodConverter
extends PsiMethodConverter {
    private static final PsiMethodConverter.MethodAccepter METHOD_ACCEPTER = new PsiMethodConverter.MethodAccepter(){

        public boolean accept(PsiMethod method) {
            return method.hasModifierProperty("public") && method.hasModifierProperty("static");
        }
    };

    protected PsiMethodConverter.MethodAccepter getMethodAccepter(ConvertContext context, boolean forCompletion) {
        return METHOD_ACCEPTER;
    }

    protected String getMethodIdentificator(PsiMethod method) {
        return SimpleMethodSignature.get(method).toString();
    }

    protected PsiMethod[] getMethodCandidates(String methodIdentificator, PsiClass psiClass) {
        methodIdentificator = (methodIdentificator = methodIdentificator.replace(" ", "")).endsWith("()") ? methodIdentificator.substring(0, methodIdentificator.length() - 2) : methodIdentificator;
        SmartList result = new SmartList();
        for (PsiMethod method : psiClass.getMethods()) {
            if (!METHOD_ACCEPTER.accept(method) || !methodIdentificator.equals(SimpleMethodSignature.get(method).toString(false))) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        if (parent instanceof SpelFunction) {
            return (PsiClass)((SpelFunction)parent).getClazz().getValue();
        }
        return null;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        SimpleMethodSignature signature;
        SpelFunction spelFunction;
        GenericAttributeValue<PsiClass> clazz;
        DomElement parent = context.getInvocationElement().getParent();
        if (parent instanceof SpelFunction && DomUtil.hasXml(clazz = (spelFunction = (SpelFunction)parent).getClazz()) && clazz.getValue() != null && (signature = SimpleMethodSignature.get(spelFunction.getMethod().getRawText())) != null) {
            return new LocalQuickFix[]{new CreateStaticMethodQuickFix((PsiClass)clazz.getValue(), signature.getMethodName(), signature.getErasedParameterTypes())};
        }
        return null;
    }
}

