/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.diagram.SpringIntegrationBeanPointerWrapper;
import com.intellij.spring.integration.diagram.SpringIntegrationDiagramProvider;
import com.intellij.spring.integration.diagram.SpringIntegrationNode;
import com.intellij.spring.integration.model.xml.core.EndpointDomBean;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.edges.MessageFlowEdge;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import icons.SpringIntegrationIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private static final HashSet<String> INBOUND_CHANNELS = new HashSet<String>(Arrays.asList("input-channel", "default-reply-channel", "reply-channel"));
    private static final HashSet<String> OUTBOUND_CHANNELS = new HashSet<String>(Arrays.asList("default-output-channel", "output-channel", "default-request-channel", "request-channel", "default-publisher-channel", "default-channel"));
    private static final HashSet<String> NON_STANDARD_OUTBOUND_CHANNELS = new HashSet<String>(Arrays.asList("error-channel", "discard-channel", "return-channel", "on-success-result-channel", "on-failure-result-channel", "confirm-ack-channel", "confirm-nack-channel"));
    private static final String CHANNEL = "channel";
    private static final HashSet<String> ROUTER_OUTBOUND_CHANNEL_PARENTS = new HashSet<String>(Arrays.asList("mapping", "recipient"));
    private static final String OUTBOUND_GATEWAY_INBOUND = "request-channel";
    private static final String OUTBOUND_GATEWAY_OUTBOUND = "reply-channel";
    private final SpringElementWrapper myElement;
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = new HashSet<DiagramNode<SpringElementWrapper>>();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = new HashSet<DiagramEdge<SpringElementWrapper>>();
    private final Collection<SpringBeanPointer> messageChannels = new HashSet<SpringBeanPointer>();

    public SpringIntegrationDataModel(Project project, SpringIntegrationDiagramProvider provider, SpringElementWrapper element) {
        super(project, (DiagramProvider)provider);
        this.myElement = element;
    }

    @NotNull
    public Collection<? extends DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper element) {
        SpringIntegrationNode node = new SpringIntegrationNode(element, (DiagramProvider<SpringElementWrapper>)this.getProvider());
        this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        return node;
    }

    public void refreshDataModel() {
        this.myEdges.clear();
        this.myNodes.clear();
        Module module = this.myElement.getModule();
        if (module == null || DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        CommonSpringModel myApplicationModel = this.myElement.getProcessingSpringModel(false);
        if (myApplicationModel == null) {
            return;
        }
        this.messageChannels.clear();
        this.messageChannels.addAll(SpringIntegrationUtil.getMessageChannels(module));
        for (SpringBeanPointer pointer : myApplicationModel.getAllDomBeans()) {
            DiagramNode<SpringElementWrapper> sourceNode;
            if (!SpringIntegrationDataModel.isIntegrationBeanPointer(pointer) || (sourceNode = this.getOrCreateElement(pointer, module)) == null) continue;
            this.processDependencies(pointer, sourceNode, module);
        }
    }

    private static boolean isIntegrationBeanPointer(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(3);
        }
        return pointer.isValid() && pointer.getSpringBean() instanceof EndpointDomBean;
    }

    protected void processDependencies(@NotNull SpringBeanPointer pointer, @NotNull DiagramNode<SpringElementWrapper> node, Module module) {
        if (pointer == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(4);
        }
        if (node == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(5);
        }
        if (this.isProcessed(node)) {
            return;
        }
        SpringIntegrationDataModel.setProcessed(node);
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof EndpointDomBean) {
            this.addPointedDependencies(node, springBean, module);
        }
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper> sourceNode, CommonSpringBean springBean, final Module module) {
        if (SpringIntegrationDataModel.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer messageChannelPointer;
                        DiagramNode<SpringElementWrapper> target;
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer && SpringIntegrationDataModel.this.messageChannels.contains(pointer) && (target = SpringIntegrationDataModel.this.getOrCreateElement(messageChannelPointer = (SpringBeanPointer)pointer, module)) != null) {
                            SpringIntegrationDataModel.this.addEdge((DiagramEdge<SpringElementWrapper>)SpringIntegrationDataModel.createIntegrationEdge((DiagramNode<SpringElementWrapper>)sourceNode, (DiagramNode<SpringElementWrapper>)target, (GenericAttributeValue)element));
                        }
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramEdge<SpringElementWrapper> edge) {
        if (edge == null) {
            return;
        }
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add(edge);
        }
    }

    private static DiagramEdge<SpringElementWrapper> createIntegrationEdge(DiagramNode<SpringElementWrapper> sourceNode, DiagramNode<SpringElementWrapper> targetNode, GenericAttributeValue identifyingAttributeValue) {
        XmlAttribute xmlAttribute = identifyingAttributeValue.getXmlAttribute();
        if (xmlAttribute == null) {
            return null;
        }
        String attributeName = xmlAttribute.getName();
        if (SpringIntegrationDataModel.isInboundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(targetNode, sourceNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isOutBoundChannel(identifyingAttributeValue, attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement());
        }
        if (SpringIntegrationDataModel.isNonStandardOutBoundChannel(attributeName)) {
            return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName);
        }
        return new MessageFlowEdge(sourceNode, targetNode, (PsiElement)identifyingAttributeValue.getXmlElement(), attributeName, true);
    }

    private static boolean isNonStandardOutBoundChannel(String attributeName) {
        return NON_STANDARD_OUTBOUND_CHANNELS.contains(attributeName);
    }

    private static boolean isOutBoundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return false;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return true;
            }
        }
        boolean inboundAdapter = SpringIntegrationIcons.Diagram.InboundAdapter.equals(parent.getPresentation().getIcon());
        boolean outboundRouter = ROUTER_OUTBOUND_CHANNEL_PARENTS.contains(parent.getXmlElementName());
        return OUTBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && (outboundRouter || inboundAdapter);
    }

    private static boolean isInboundChannel(GenericAttributeValue identifyingAttributeValue, String attributeName) {
        DomElement parent = identifyingAttributeValue.getParent();
        if (SpringIntegrationIcons.Diagram.OutboundGateway.equals(parent.getPresentation().getIcon())) {
            if (OUTBOUND_GATEWAY_INBOUND.equals(attributeName)) {
                return true;
            }
            if (OUTBOUND_GATEWAY_OUTBOUND.equals(attributeName)) {
                return false;
            }
        }
        boolean outboundAdapter = SpringIntegrationIcons.Diagram.OutboundAdapter.equals(parent.getPresentation().getIcon());
        return INBOUND_CHANNELS.contains(attributeName) || CHANNEL.equals(attributeName) && outboundAdapter;
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        if (targetNode == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(6);
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        Boolean isProcessed;
        if (targetNode == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(7);
        }
        return (isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY)) != null && isProcessed != false;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> getOrCreateElement(SpringBeanPointer beanPointer, Module module) {
        DiagramNode<SpringElementWrapper> target = this.getNode(beanPointer);
        if (target == null) {
            target = this.addNode(beanPointer, module);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull SpringBeanPointer bean) {
        if (bean == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(8);
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addNode(SpringBeanPointer element, Module module) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringIntegrationBeanPointerWrapper.createIntegrationBeanWrapper(element, module));
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper beanPointerWrapper) {
        SpringIntegrationNode node = new SpringIntegrationNode(beanPointerWrapper, (DiagramProvider<SpringElementWrapper>)this.getProvider());
        if (!this.myNodes.contains((Object)node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
        if (domManager == null) {
            SpringIntegrationDataModel.$$$reportNull$$$0(9);
        }
        return domManager;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/diagram/SpringIntegrationDataModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/diagram/SpringIntegrationDataModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIntegrationBeanPointer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProcessed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

