/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import icons.SpringIntegrationIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationBeanPointerWrapper
extends SpringBeanPointerWrapper {
    private SpringIntegrationBeanPointerWrapper(@NotNull SpringBeanPointer pointer, Module module) {
        if (pointer == null) {
            SpringIntegrationBeanPointerWrapper.$$$reportNull$$$0(0);
        }
        super(pointer, module);
    }

    public static SpringIntegrationBeanPointerWrapper createIntegrationBeanWrapper(SpringBeanPointer pointer, Module module) {
        return new SpringIntegrationBeanPointerWrapper(pointer, module);
    }

    public String getName() {
        return "";
    }

    public Icon getIcon() {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        if (wrapped.isValid()) {
            CommonSpringBean bean = wrapped.getSpringBean();
            if (bean instanceof DomSpringBean) {
                return ((DomSpringBean)bean).getPresentation().getIcon();
            }
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
            if (beanClass != null && "org.springframework.integration.channel.DirectChannel".equals(beanClass.getQualifiedName())) {
                return SpringIntegrationIcons.Diagram.Channel;
            }
        }
        return super.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/integration/diagram/SpringIntegrationBeanPointerWrapper", "<init>"));
    }
}

