/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.util.Bitstream;
import java.io.IOException;
import java.io.RandomAccessFile;

class IOUtils {
    static final long MAX_INT_VALUE = Integer.MAX_VALUE;

    IOUtils() {
    }

    static String toHexString(int n) {
        String string = String.valueOf(Integer.toHexString(n));
        return string.length() != 0 ? "0x".concat(string) : new String("0x");
    }

    static String toHexString(long l) {
        String string = String.valueOf(Long.toHexString(l));
        return string.length() != 0 ? "0x".concat(string) : new String("0x");
    }

    static int shortToInt(short s) {
        return s & 0xFFFF;
    }

    static int long2Int(long l) {
        if (Integer.MAX_VALUE < l) {
            String string = IOUtils.toHexString(l);
            String string2 = IOUtils.toHexString(Integer.MAX_VALUE);
            throw new IllegalArgumentException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Read uint32 value ").append(string).append(" > int32-max ").append(string2).toString());
        }
        return (int)l;
    }

    static void readBytes(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2) throws IOException, IllegalArgumentException {
        randomAccessFile.readFully(byArray, n, n2);
    }

    static void seek(RandomAccessFile randomAccessFile, long l) throws IOException {
        randomAccessFile.seek(l);
    }

    static int readUInt32(boolean bl, byte[] byArray, int n) {
        int n2 = Bitstream.uint32LongToInt(Bitstream.readUInt32(bl, byArray, n));
        if (0 > n2) {
            String string = IOUtils.toHexString(n2);
            String string2 = IOUtils.toHexString(Integer.MAX_VALUE);
            throw new IllegalArgumentException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Read uint32 value ").append(string).append(" > int32-max ").append(string2).toString());
        }
        return n2;
    }

    static String getString(byte[] byArray, int n, int n2, int[] nArray) throws IndexOutOfBoundsException {
        String string;
        int n3;
        Bitstream.checkBounds(byArray, n, n2);
        for (n3 = 0; n3 < n2 && byArray[n3 + n] != 0; ++n3) {
        }
        String string2 = string = 0 < n3 ? new String(byArray, n, n3) : "";
        if (null != nArray) {
            nArray[0] = n + n3 + 1;
        }
        return string;
    }

    static int getStringCount(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            while (i < n2 && byArray[i + n] != 0) {
                ++i;
            }
            ++n3;
        }
        return n3;
    }

    public static String[] getStrings(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        int n3 = IOUtils.getStringCount(byArray, n, n2);
        String[] stringArray = new String[n3];
        int[] nArray = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = IOUtils.getString(byArray, nArray[0], n2 - nArray[0], nArray);
        }
        return stringArray;
    }
}

