/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");
    private static final int BUFFER_SIZE = 4096;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (resolver == null) {
            throw new IllegalArgumentException("Null Resolver passed");
        }
        if (JarUtil.resolver != null) {
            throw new IllegalStateException("Resolver already set!");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        JarUtil.resolver = resolver;
    }

    public static boolean hasJarUri(String string, ClassLoader classLoader) {
        try {
            return null != JarUtil.getJarUri(string, classLoader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Uri getJarUri(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        Uri uri;
        Object object;
        if (null == string || null == classLoader) {
            String string2 = String.valueOf(classLoader);
            throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("null arguments: clazzBinName ").append(string).append(", cl ").append(string2).toString());
        }
        URL uRL = IOUtil.getClassURL(string, classLoader);
        String string3 = uRL.getProtocol();
        if (!(null == resolver || string3.equals("jar") || string3.equals("file") || string3.equals("http") || string3.equals("https"))) {
            object = resolver.resolve(uRL);
            uri = Uri.valueOf((URL)object);
            if (DEBUG) {
                String string4 = String.valueOf(uRL);
                String string5 = String.valueOf(object);
                String string6 = String.valueOf(uri);
                System.err.println(new StringBuilder(30 + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("getJarUri Resolver: ").append(string4).append("\n\t-> ").append(string5).append("\n\t-> ").append(string6).toString());
            }
        } else {
            uri = Uri.valueOf(uRL);
            if (DEBUG) {
                object = String.valueOf(uRL);
                String string7 = String.valueOf(uri);
                System.err.println(new StringBuilder(23 + String.valueOf(object).length() + String.valueOf(string7).length()).append("getJarUri Default ").append((String)object).append("\n\t-> ").append(string7).toString());
            }
        }
        if (!uri.isJarScheme()) {
            string3 = String.valueOf("Uri is not using scheme jar: <");
            object = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(object).length()).append(string3).append((String)object).append(">").toString());
        }
        if (DEBUG) {
            string3 = String.valueOf(uRL);
            object = String.valueOf(uri);
            System.err.println(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(object).length()).append("getJarUri res: ").append(string).append(" -> ").append(string3).append(" -> ").append((String)object).toString());
        }
        return uri;
    }

    public static Uri.Encoded getJarBasename(Uri uri) throws IllegalArgumentException {
        if (null == uri) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            String string = String.valueOf("Uri is not using scheme jar: <");
            String string2 = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(">").toString());
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n = encoded.lastIndexOf(33);
        if (0 > n) {
            String string = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string).length()).append("Uri does not contain jar uri terminator '!', in <").append(string).append(">").toString());
        }
        encoded = encoded.substring(0, n);
        n = encoded.lastIndexOf(47);
        if (0 > n && 0 > (n = encoded.lastIndexOf(58))) {
            String string = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(string).length()).append("Uri does not contain protocol terminator ':', in <").append(string).append(">").toString());
        }
        if (0 >= (encoded = encoded.substring(n + 1)).lastIndexOf(".jar")) {
            String string = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(17 + String.valueOf(string).length()).append("No Jar name in <").append(string).append(">").toString());
        }
        if (DEBUG) {
            String string = String.valueOf(encoded);
            System.err.println(new StringBuilder(16 + String.valueOf(string).length()).append("getJarName res: ").append(string).toString());
        }
        return encoded;
    }

    public static Uri.Encoded getJarBasename(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarBasename(JarUtil.getJarUri(string, classLoader));
    }

    public static Uri.Encoded getJarEntry(Uri uri) {
        if (null == uri) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            String string = String.valueOf("Uri is not a using scheme jar: <");
            String string2 = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(">").toString());
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n = encoded.lastIndexOf(33);
        if (0 <= n) {
            Uri.Encoded encoded2 = encoded.substring(n + 1);
            if (DEBUG) {
                String string = String.valueOf(uri);
                String string3 = String.valueOf(encoded);
                String string4 = String.valueOf(encoded2);
                System.err.println(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("getJarEntry res: ").append(string).append(" -> ").append(string3).append(" -> ").append(n).append(" -> ").append(string4).toString());
            }
            return encoded2;
        }
        String string = String.valueOf(uri);
        throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string).length()).append("JAR Uri does not contain jar uri terminator '!', uri <").append(string).append(">").toString());
    }

    public static Uri getJarFileUri(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        if (null == string || null == classLoader) {
            String string2 = String.valueOf(classLoader);
            throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("null arguments: clazzBinName ").append(string).append(", cl ").append(string2).toString());
        }
        Uri uri = JarUtil.getJarUri(string, classLoader).getContainedUri();
        String string3 = String.valueOf("jar:");
        String string4 = String.valueOf(uri.toString());
        Uri uri2 = Uri.cast(new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(string4).append("!/").toString());
        if (DEBUG) {
            string3 = String.valueOf(uri2);
            System.err.println(new StringBuilder(19 + String.valueOf(string3).length()).append("getJarFileUri res: ").append(string3).toString());
        }
        return uri2;
    }

    public static Uri getJarFileUri(Uri uri, Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == uri || null == encoded) {
            String string = String.valueOf(uri);
            String string2 = String.valueOf(encoded);
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("null arguments: baseUri ").append(string).append(", jarFileName ").append(string2).toString());
        }
        String string = String.valueOf("jar:");
        String string3 = String.valueOf(uri.toString());
        String string4 = String.valueOf(encoded);
        return Uri.cast(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string3).append(string4).append("!/").toString());
    }

    public static Uri getJarFileUri(Uri uri) throws IllegalArgumentException, URISyntaxException {
        if (null == uri) {
            throw new IllegalArgumentException("jarSubUri is null");
        }
        String string = String.valueOf("jar:");
        String string2 = String.valueOf(uri.toString());
        return Uri.cast(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("!/").toString());
    }

    public static Uri getJarFileUri(Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == encoded) {
            throw new IllegalArgumentException("jarSubUriS is null");
        }
        String string = String.valueOf("jar:");
        String string2 = String.valueOf(encoded);
        return Uri.cast(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("!/").toString());
    }

    public static Uri getJarEntryUri(Uri uri, Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == encoded) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        String string = String.valueOf(uri.toString());
        String string2 = String.valueOf(encoded);
        return Uri.cast(new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) throws IOException, IllegalArgumentException, URISyntaxException {
        return JarUtil.getJarFile(JarUtil.getJarFileUri(string, classLoader));
    }

    public static JarFile getJarFile(Uri uri) throws IOException, IllegalArgumentException, URISyntaxException {
        URLConnection uRLConnection;
        if (null == uri) {
            throw new IllegalArgumentException("null jarFileUri");
        }
        if (DEBUG) {
            String string = String.valueOf(uri.toString());
            System.err.println(string.length() != 0 ? "getJarFile.0: ".concat(string) : new String("getJarFile.0: "));
        }
        URL uRL = uri.toURL();
        if (DEBUG) {
            String string = String.valueOf(uRL.toString());
            System.err.println(string.length() != 0 ? "getJarFile.1: ".concat(string) : new String("getJarFile.1: "));
        }
        if ((uRLConnection = uRL.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (DEBUG) {
                String string = String.valueOf(jarFile.getName());
                System.err.println(string.length() != 0 ? "getJarFile res: ".concat(string) : new String("getJarFile res: "));
            }
            return jarFile;
        }
        if (DEBUG) {
            System.err.println("getJarFile res: NULL");
        }
        return null;
    }

    public static URI getRelativeOf(Class<?> clazz, String string, String string2) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getRelativeOf(clazz, Uri.Encoded.cast(string), Uri.Encoded.cast(string2)).toURI();
    }

    public static Uri getRelativeOf(Class<?> clazz, Uri.Encoded encoded, Uri.Encoded encoded2) throws IllegalArgumentException, IOException, URISyntaxException {
        String string;
        Object object;
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object2;
        ClassLoader classLoader = clazz.getClassLoader();
        Uri uri = JarUtil.getJarUri(clazz.getName(), classLoader);
        if (DEBUG) {
            object2 = String.valueOf("JarUtil.getRelativeOf: (classFromJavaJar ");
            charSequence2 = String.valueOf(clazz);
            charSequence = String.valueOf(uri);
            object = String.valueOf(encoded);
            string = String.valueOf(encoded2);
            System.err.println(new StringBuilder(49 + String.valueOf(object2).length() + String.valueOf(charSequence2).length() + String.valueOf(charSequence).length() + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object2).append((String)charSequence2).append(", classJarUri ").append((String)charSequence).append(", cutOffInclSubDir ").append((String)object).append(", relResPath ").append(string).append("): ").toString());
        }
        if (null == (object2 = uri.getContainedUri())) {
            charSequence2 = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(charSequence2).length()).append("JarSubUri is null of: ").append((String)charSequence2).toString());
        }
        charSequence2 = ((Uri)object2).getDirectory().getEncoded();
        if (DEBUG) {
            charSequence = String.valueOf("JarUtil.getRelativeOf: uri ");
            object = String.valueOf(((Uri)object2).toString());
            string = String.valueOf(charSequence2);
            System.err.println(new StringBuilder(4 + String.valueOf(charSequence).length() + String.valueOf(object).length() + String.valueOf(string).length()).append((String)charSequence).append((String)object).append(" -> ").append(string).toString());
        }
        charSequence = ((Uri.Encoded)charSequence2).endsWith(encoded.get()) ? ((Uri.Encoded)charSequence2).concat(encoded2) : ((Uri.Encoded)charSequence2).concat(encoded).concat(encoded2);
        if (DEBUG) {
            object = String.valueOf("JarUtil.getRelativeOf: ...  -> ");
            string = String.valueOf(charSequence);
            System.err.println(new StringBuilder(0 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(string).toString());
        }
        object = JarUtil.getJarFileUri((Uri.Encoded)charSequence);
        if (DEBUG) {
            string = String.valueOf("JarUtil.getRelativeOf: fin ");
            String string2 = String.valueOf(object);
            System.err.println(new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
        }
        return object;
    }

    public static Map<String, String> getNativeLibNames(JarFile jarFile) {
        Object object;
        if (DEBUG) {
            object = String.valueOf(jarFile);
            System.err.println(new StringBuilder(28 + String.valueOf(object).length()).append("JarUtil: getNativeLibNames: ").append((String)object).toString());
        }
        object = new HashMap();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            if (null == string2) continue;
            object.put(string2, string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int extract(File file, Map<String, String> map, JarFile jarFile, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Object object;
        if (DEBUG) {
            String string2 = String.valueOf(jarFile.getName());
            object = String.valueOf(file);
            System.err.println(new StringBuilder(105 + String.valueOf(string2).length() + String.valueOf(object).length() + String.valueOf(string).length()).append("JarUtil: extract: ").append(string2).append(" -> ").append((String)object).append(", extractNativeLibraries ").append(bl).append(" (").append(string).append(")").append(", extractClassFiles ").append(bl2).append(", extractOtherFiles ").append(bl3).toString());
        }
        int n = 0;
        object = jarFile.entries();
        while (object.hasMoreElements()) {
            Object object2;
            Object object3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            JarEntry jarEntry = (JarEntry)object.nextElement();
            String string3 = jarEntry.getName();
            String string4 = NativeLibrary.isValidNativeLibraryName(string3, false);
            boolean bl7 = bl6 = null != string4;
            if (bl6) {
                if (!bl) {
                    if (!DEBUG) continue;
                    System.err.println(new StringBuilder(61 + String.valueOf(string3).length()).append("JarUtil: JarEntry : ").append(string3).append(" native-lib skipped, skip all native libs").toString());
                    continue;
                }
                if (null != string) {
                    String string5;
                    String string6;
                    try {
                        string6 = IOUtil.slashify(string, false, true);
                        string5 = IOUtil.getDirname(string3);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IOException(uRISyntaxException);
                    }
                    if (!string6.equals(string5)) {
                        if (!DEBUG) continue;
                        System.err.println(new StringBuilder(54 + String.valueOf(string3).length() + String.valueOf(string6).length()).append("JarUtil: JarEntry : ").append(string3).append(" native-lib skipped, not in path: ").append(string6).toString());
                        continue;
                    }
                }
            }
            if ((bl5 = string3.endsWith(".class")) && !bl2) {
                if (!DEBUG) continue;
                System.err.println(new StringBuilder(39 + String.valueOf(string3).length()).append("JarUtil: JarEntry : ").append(string3).append(" class-file skipped").toString());
                continue;
            }
            if (!(bl6 || bl5 || bl3)) {
                if (!DEBUG) continue;
                System.err.println(new StringBuilder(39 + String.valueOf(string3).length()).append("JarUtil: JarEntry : ").append(string3).append(" other-file skipped").toString());
                continue;
            }
            boolean bl8 = string3.endsWith("/");
            boolean bl9 = bl4 = string3.indexOf(47) == -1 && string3.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println(new StringBuilder(88).append("JarUtil: JarEntry : isNativeLib ").append(bl6).append(", isClassFile ").append(bl5).append(", isDir ").append(bl8).append(", isRootEntry ").append(bl4).toString());
            }
            File file2 = new File(file, string3);
            if (bl8) {
                if (DEBUG) {
                    object3 = String.valueOf(file2);
                    System.err.println(new StringBuilder(20 + String.valueOf(string3).length() + String.valueOf(object3).length()).append("JarUtil: MKDIR: ").append(string3).append(" -> ").append((String)object3).toString());
                }
                file2.mkdirs();
                continue;
            }
            object3 = new File(file2.getParent());
            if (!((File)object3).exists()) {
                if (DEBUG) {
                    object2 = String.valueOf(object3);
                    System.err.println(new StringBuilder(29 + String.valueOf(string3).length() + String.valueOf(object2).length()).append("JarUtil: MKDIR (parent): ").append(string3).append(" -> ").append((String)object2).toString());
                }
                ((File)object3).mkdirs();
            }
            object2 = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = -1;
            try {
                n2 = IOUtil.copyStream2Stream(4096, (InputStream)object2, bufferedOutputStream, -1);
            }
            finally {
                ((InputStream)object2).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            boolean bl10 = false;
            if (n2 > 0) {
                ++n;
                if (bl6 && (bl4 || !map.containsKey(string4))) {
                    map.put(string4, file2.getAbsolutePath());
                    bl10 = true;
                    JarUtil.fixNativeLibAttribs(file2);
                }
            }
            if (!DEBUG) continue;
            int n3 = n;
            String string7 = String.valueOf(file2);
            int n4 = n2;
            boolean bl11 = bl10;
            System.err.println(new StringBuilder(86 + String.valueOf(string4).length() + String.valueOf(string3).length() + String.valueOf(string7).length()).append("JarUtil: EXTRACT[").append(n3).append("]: [").append(string4).append(" -> ] ").append(string3).append(" -> ").append(string7).append(": ").append(n4).append(" bytes, addedAsNativeLib: ").append(bl11).toString());
        }
        return n;
    }

    private static final void fixNativeLibAttribs(File file) {
        block4: {
            if (Platform.OSType.MACOS == Platform.getOSType()) {
                String string = file.getAbsolutePath();
                try {
                    JarUtil.fixNativeLibAttribs(string);
                    if (DEBUG) {
                        System.err.println(new StringBuilder(34 + String.valueOf(string).length()).append("JarUtil.fixNativeLibAttribs: ").append(string).append(" - OK").toString());
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    String string2 = String.valueOf(throwable.getClass().getSimpleName());
                    String string3 = String.valueOf(throwable.getMessage());
                    System.err.println(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JarUtil.fixNativeLibAttribs: ").append(string).append(" - ").append(string2).append(": ").append(string3).toString());
                }
            }
        }
    }

    private static native boolean fixNativeLibAttribs(String var0);

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) throws IOException, SecurityException {
        if (DEBUG) {
            String string = String.valueOf(jarFile.getName());
            System.err.println(string.length() != 0 ? "JarUtil: validateCertificates: ".concat(string) : new String("JarUtil: validateCertificates: "));
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException, SecurityException {
        if (DEBUG) {
            String string = String.valueOf(jarEntry.getName());
            System.err.println(string.length() != 0 ? "JarUtil: validate JarEntry : ".concat(string) : new String("JarUtil: validate JarEntry : "));
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            while (inputStream.read(byArray) > 0) {
            }
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            String string = String.valueOf(jarEntry.getName());
            String string2 = String.valueOf(jarFile.getName());
            throw new SecurityException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("no certificate for ").append(string).append(" in ").append(string2).toString());
        }
        if (!SecurityUtil.equals(certificateArray, certificateArray2)) {
            String string = String.valueOf(jarEntry.getName());
            String string3 = String.valueOf(jarFile.getName());
            throw new SecurityException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string3).length()).append("certificates not equal for ").append(string).append(" in ").append(string3).toString());
        }
    }

    public static interface Resolver {
        public URL resolve(URL var1);
    }
}

