/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class MavenProjectProblem
implements Serializable {
    private final String myPath;
    private final String myDescription;
    private final ProblemType myType;

    public static MavenProjectProblem createStructureProblem(String path, String description) {
        return MavenProjectProblem.createProblem(path, description, ProblemType.STRUCTURE);
    }

    public static MavenProjectProblem createSyntaxProblem(String path, ProblemType type) {
        return MavenProjectProblem.createProblem(path, MessageFormat.format("''{0}'' has syntax errors", new File(path).getName()), type);
    }

    public static MavenProjectProblem createProblem(String path, String description, ProblemType type) {
        return new MavenProjectProblem(path, description, type);
    }

    public static Collection<MavenProjectProblem> createProblemsList() {
        return MavenProjectProblem.createProblemsList(Collections.<MavenProjectProblem>emptySet());
    }

    public static Collection<MavenProjectProblem> createProblemsList(Collection<MavenProjectProblem> copyThis) {
        return new LinkedHashSet<MavenProjectProblem>(copyThis);
    }

    public MavenProjectProblem(String path, String description, ProblemType type) {
        this.myPath = path;
        this.myDescription = description;
        this.myType = type;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public ProblemType getType() {
        return this.myType;
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myDescription + ":" + this.myPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenProjectProblem that = (MavenProjectProblem)o;
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        if (this.myType != that.myType) {
            return false;
        }
        return !(this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null);
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    public static enum ProblemType {
        SYNTAX,
        STRUCTURE,
        DEPENDENCY,
        PARENT,
        SETTINGS_OR_PROFILES;

    }
}

