/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class CaptureAgent {
    private static Instrumentation ourInstrumentation;
    private static boolean DEBUG;
    private static Map<String, List<CapturePoint>> myCapturePoints;
    private static Map<String, List<InsertPoint>> myInsertPoints;
    static final KeyProvider THIS_KEY_PROVIDER;

    public static void premain(String args, Instrumentation instrumentation) {
        ourInstrumentation = instrumentation;
        try {
            String asmPath = CaptureAgent.readSettings(args);
            if (asmPath == null) {
                return;
            }
            try {
                instrumentation.appendToSystemClassLoaderSearch(new JarFile(asmPath));
            }
            catch (Exception e) {
                String report = "Capture agent: unable to use the provided asm lib";
                try {
                    Class.forName("org.jetbrains.org.objectweb.asm.MethodVisitor");
                    System.out.println(report + ", will use asm from the classpath");
                }
                catch (ClassNotFoundException e1) {
                    System.out.println(report + ", exiting");
                    return;
                }
            }
            instrumentation.addTransformer(new CaptureTransformer());
            CaptureAgent.setupJboss();
            if (DEBUG) {
                System.out.println("Capture agent: ready");
            }
        }
        catch (Throwable e) {
            System.out.println("Capture agent: unknown exception");
            e.printStackTrace();
        }
    }

    private static void setupJboss() {
        String modulesKey = "jboss.modules.system.pkgs";
        String property = System.getProperty(modulesKey, "");
        if (!property.isEmpty()) {
            property = property + ",";
        }
        property = property + "com.intellij.rt";
        System.setProperty(modulesKey, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSettings(String path) {
        FileReader reader = null;
        try {
            reader = new FileReader(path);
            Properties properties = new Properties();
            properties.load(reader);
            DEBUG = Boolean.parseBoolean(properties.getProperty("debug", "false"));
            if (DEBUG) {
                CaptureStorage.setDebug((boolean)true);
            }
            if (Boolean.parseBoolean(properties.getProperty("disabled", "false"))) {
                CaptureStorage.setEnabled((boolean)false);
            }
            boolean deleteSettings = Boolean.parseBoolean(properties.getProperty("deleteSettings", "true"));
            String asmPath = properties.getProperty("asm-lib");
            if (asmPath == null) {
                System.out.println("Capture agent: asm path is not specified, exiting");
                String string = null;
                return string;
            }
            Enumeration<?> propNames = properties.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                if (propName.startsWith("capture")) {
                    CaptureAgent.addPoint(true, properties.getProperty(propName));
                    continue;
                }
                if (!propName.startsWith("insert")) continue;
                CaptureAgent.addPoint(false, properties.getProperty(propName));
            }
            if (deleteSettings) {
                new File(path).delete();
            }
            String string = asmPath;
            return string;
        }
        catch (IOException e) {
            System.out.println("Capture agent: unable to read settings");
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static <T> List<T> getNotNull(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static void setCapturePoints(Object[][] capturePoints) throws UnmodifiableClassException {
        HashSet<String> classNames = new HashSet<String>(myCapturePoints.keySet());
        HashMap<String, List<CapturePoint>> points = new HashMap<String, List<CapturePoint>>();
        for (Object[] capturePoint : capturePoints) {
            String className = (String)capturePoint[0];
            classNames.add(className);
            ArrayList currentPoints = (ArrayList)points.get(className);
            if (currentPoints != null) continue;
            currentPoints = new ArrayList();
            points.put(className, currentPoints);
        }
        myCapturePoints = points;
        ArrayList classes = new ArrayList(capturePoints.length);
        for (String name : classNames) {
            try {
                classes.add(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        ourInstrumentation.retransformClasses(classes.toArray(new Class[0]));
    }

    private static void addPoint(boolean capture, String line) {
        String[] split = line.split(" ");
        KeyProvider keyProvider = CaptureAgent.createKeyProvider(Arrays.copyOfRange(split, 2, split.length));
        if (capture) {
            CaptureAgent.addCapturePoint(split[0], split[1], keyProvider);
        } else {
            CaptureAgent.addInsertPoint(split[0], split[1], keyProvider);
        }
    }

    private static void addCapturePoint(String className, String methodName, KeyProvider keyProvider) {
        List<CapturePoint> points = myCapturePoints.get(className);
        if (points == null) {
            points = new ArrayList<CapturePoint>();
            myCapturePoints.put(className, points);
        }
        points.add(new CapturePoint(className, methodName, keyProvider));
    }

    private static void addInsertPoint(String className, String methodName, KeyProvider keyProvider) {
        List<InsertPoint> points = myInsertPoints.get(className);
        if (points == null) {
            points = new ArrayList<InsertPoint>();
            myInsertPoints.put(className, points);
        }
        points.add(new InsertPoint(className, methodName, keyProvider));
    }

    private static KeyProvider createKeyProvider(String[] line) {
        if ("this".equals(line[0])) {
            return THIS_KEY_PROVIDER;
        }
        try {
            return new ParamKeyProvider(Integer.parseInt(line[0]));
        }
        catch (NumberFormatException numberFormatException) {
            return new FieldKeyProvider(line[0], line[1], line[2]);
        }
    }

    static {
        DEBUG = false;
        myCapturePoints = new HashMap<String, List<CapturePoint>>();
        myInsertPoints = new HashMap<String, List<InsertPoint>>();
        THIS_KEY_PROVIDER = new KeyProvider(){

            @Override
            public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
                if (isStatic) {
                    throw new IllegalStateException("This is not available in a static method " + methodDisplayName);
                }
                mv.visitVarInsn(25, 0);
            }
        };
    }

    private static class ParamKeyProvider
    implements KeyProvider {
        int myIdx;

        public ParamKeyProvider(int idx) {
            this.myIdx = idx;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            int index;
            int n = index = isStatic ? 0 : 1;
            if (this.myIdx >= argumentTypes.length) {
                throw new IllegalStateException("Argument with id " + this.myIdx + " is not available, method " + methodDisplayName + " has only " + argumentTypes.length);
            }
            for (int i = 0; i < this.myIdx; ++i) {
                index += argumentTypes[i].getSize();
            }
            mv.visitVarInsn(25, index);
        }
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        String myClassName;
        String myFieldName;
        String myFieldDesc;

        public FieldKeyProvider(String className, String fieldName, String fieldDesc) {
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.myFieldDesc = fieldDesc;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.myClassName, this.myFieldName, this.myFieldDesc);
        }
    }

    private static interface KeyProvider {
        public void loadKey(MethodVisitor var1, boolean var2, Type[] var3, String var4);
    }

    static class InsertPoint {
        final String myClassName;
        final String myMethodName;
        final KeyProvider myKeyProvider;

        public InsertPoint(String className, String methodName, KeyProvider keyProvider) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myKeyProvider = keyProvider;
        }
    }

    static class CapturePoint {
        final String myClassName;
        final String myMethodName;
        final KeyProvider myKeyProvider;

        public CapturePoint(String className, String methodName, KeyProvider keyProvider) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myKeyProvider = keyProvider;
        }
    }

    private static class CaptureInstrumentor
    extends ClassVisitor {
        private final List<CapturePoint> myCapturePoints;
        private final List<InsertPoint> myInsertPoints;

        public CaptureInstrumentor(int api, ClassVisitor cv, List<CapturePoint> capturePoints, List<InsertPoint> insertPoints) {
            super(api, cv);
            this.myCapturePoints = capturePoints;
            this.myInsertPoints = insertPoints;
        }

        private static String getNewName(String name) {
            return name + "$$$capture";
        }

        private static String getMethodDisplayName(String className, String methodName, String desc) {
            return className + "." + methodName + desc;
        }

        public MethodVisitor visitMethod(final int access, String name, final String desc, String signature, String[] exceptions) {
            if ((access & 0x40) == 0) {
                for (final CapturePoint capturePoint : this.myCapturePoints) {
                    if (!capturePoint.myMethodName.equals(name)) continue;
                    final String methodDisplayName = CaptureInstrumentor.getMethodDisplayName(capturePoint.myClassName, name, desc);
                    if (DEBUG) {
                        System.out.println("Capture agent: instrumented capture point at " + methodDisplayName);
                    }
                    if ("<init>".equals(name) && capturePoint.myKeyProvider == THIS_KEY_PROVIDER) {
                        return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                            public void visitInsn(int opcode) {
                                if (opcode == 177) {
                                    CaptureInstrumentor.capture(this.mv, capturePoint.myKeyProvider, (access & 8) != 0, Type.getMethodType((String)desc).getArgumentTypes(), methodDisplayName);
                                }
                                super.visitInsn(opcode);
                            }
                        };
                    }
                    return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                        public void visitCode() {
                            CaptureInstrumentor.capture(this.mv, capturePoint.myKeyProvider, (access & 8) != 0, Type.getMethodType((String)desc).getArgumentTypes(), methodDisplayName);
                            super.visitCode();
                        }
                    };
                }
                for (InsertPoint insertPoint : this.myInsertPoints) {
                    if (!insertPoint.myMethodName.equals(name)) continue;
                    String methodDisplayName = CaptureInstrumentor.getMethodDisplayName(insertPoint.myClassName, name, desc);
                    if (DEBUG) {
                        System.out.println("Capture agent: instrumented insert point at " + methodDisplayName);
                    }
                    this.generateWrapper(access, name, desc, signature, exceptions, insertPoint, methodDisplayName);
                    return super.visitMethod(access, CaptureInstrumentor.getNewName(name), desc, signature, exceptions);
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private void generateWrapper(int access, String name, String desc, String signature, String[] exceptions, InsertPoint insertPoint, String methodDisplayName) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Label start = new Label();
            mv.visitLabel(start);
            boolean isStatic = (access & 8) != 0;
            Type[] argumentTypes = Type.getMethodType((String)desc).getArgumentTypes();
            CaptureInstrumentor.insertEnter(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitVarInsn(25, 0);
            int index = isStatic ? 0 : 1;
            for (Type t : argumentTypes) {
                mv.visitVarInsn(t.getOpcode(21), index);
                index += t.getSize();
            }
            mv.visitMethodInsn(isStatic ? 184 : 183, insertPoint.myClassName, CaptureInstrumentor.getNewName(insertPoint.myMethodName), desc, false);
            Label end = new Label();
            mv.visitLabel(end);
            CaptureInstrumentor.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(Type.getReturnType((String)desc).getOpcode(172));
            Label catchLabel = new Label();
            mv.visitLabel(catchLabel);
            mv.visitTryCatchBlock(start, end, catchLabel, null);
            CaptureInstrumentor.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(191);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void capture(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            CaptureInstrumentor.storageCall(mv, keyProvider, isStatic, argumentTypes, "capture", methodDisplayName);
        }

        private static void insertEnter(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            CaptureInstrumentor.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertEnter", methodDisplayName);
        }

        private static void insertExit(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            CaptureInstrumentor.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertExit", methodDisplayName);
        }

        private static void storageCall(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String storageMethodName, String methodDisplayName) {
            keyProvider.loadKey(mv, isStatic, argumentTypes, methodDisplayName);
            mv.visitMethodInsn(184, CaptureStorage.class.getName().replaceAll("\\.", "/"), storageMethodName, "(Ljava/lang/Object;)V", false);
        }
    }

    private static class CaptureTransformer
    implements ClassFileTransformer {
        private CaptureTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (className != null) {
                List capturePoints = CaptureAgent.getNotNull((List)myCapturePoints.get(className));
                List insertPoints = CaptureAgent.getNotNull((List)myInsertPoints.get(className));
                if (!capturePoints.isEmpty() || !insertPoints.isEmpty()) {
                    try {
                        ClassReader reader = new ClassReader(classfileBuffer);
                        ClassWriter writer = new ClassWriter(reader, 2);
                        reader.accept((ClassVisitor)new CaptureInstrumentor(393216, (ClassVisitor)writer, capturePoints, insertPoints), 0);
                        byte[] bytes = writer.toByteArray();
                        if (DEBUG) {
                            try {
                                FileOutputStream stream = new FileOutputStream("instrumented_" + className.replaceAll("/", "_") + ".class");
                                try {
                                    stream.write(bytes);
                                }
                                finally {
                                    stream.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        return bytes;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
    }
}

