/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.configuration;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportProvider;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportTemplatesRunner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransportSupportFix
implements LocalQuickFix,
IntentionAction {
    private final SmartPsiElementPointer<XmlFile> myXmlFilePointer;

    public AbstractTransportSupportFix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(0);
        }
        this.myXmlFilePointer = SmartPointerManager.getInstance((Project)xmlFile.getProject()).createSmartPsiElementPointer((PsiElement)xmlFile);
    }

    protected abstract FrameworkSupportProvider getFrameworkSupportProvider();

    protected void doFix(Project project) {
        XmlFile xmlFile = (XmlFile)this.myXmlFilePointer.getElement();
        if (xmlFile == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlFile);
        Editor textEditor = FileEditorManager.getInstance((Project)xmlFile.getProject()).getSelectedTextEditor();
        if (module != null && textEditor != null) {
            FrameworkSupportTemplatesRunner.getInstance().generateSpringBeans(this.getFrameworkSupportProvider(), module, textEditor, xmlFile);
        }
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(4);
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            AbstractTransportSupportFix.$$$reportNull$$$0(6);
        }
        this.doFix(project);
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/inspections/configuration/AbstractTransportSupportFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

