/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.jsp;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.CustomServletReferenceAdapter;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.struts2.model.constant.StrutsConstantHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.Struts2Icons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionLinkReferenceProvider
extends CustomServletReferenceAdapter {
    protected PsiReference[] createReferences(@NotNull PsiElement psiElement, int offset, String text, @Nullable ServletMappingInfo info, boolean soft) {
        StrutsModel strutsModel;
        if (psiElement == null) {
            ActionLinkReferenceProvider.$$$reportNull$$$0(0);
        }
        if ((strutsModel = StrutsManager.getInstance(psiElement.getProject()).getCombinedModel(psiElement)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        List<String> actionExtensions = StrutsConstantHelper.getActionExtensions(psiElement);
        if (actionExtensions.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (text.indexOf(47) != -1) {
            return new PsiReference[]{new ActionLinkPackageReference(psiElement, offset, text, soft, strutsModel), new ActionLinkReference(psiElement, offset, text, soft, strutsModel, actionExtensions)};
        }
        return new PsiReference[]{new ActionLinkReference(psiElement, offset, text, soft, strutsModel, actionExtensions)};
    }

    @Nullable
    public PathReference createWebPath(String path, @NotNull PsiElement psiElement, ServletMappingInfo servletMappingInfo) {
        StrutsManager strutsManager;
        if (psiElement == null) {
            ActionLinkReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((strutsManager = StrutsManager.getInstance(psiElement.getProject())).getCombinedModel(psiElement) == null) {
            return null;
        }
        return new PathReference(path, (Function)new ConstantFunction((Object)Struts2Icons.Action));
    }

    @NotNull
    private static String getNamespace(String fullActionPath) {
        int lastSlash = fullActionPath.lastIndexOf(47);
        if (lastSlash == -1) {
            if ("/" == null) {
                ActionLinkReferenceProvider.$$$reportNull$$$0(2);
            }
            return "/";
        }
        if (lastSlash == 0) {
            if ("/" == null) {
                ActionLinkReferenceProvider.$$$reportNull$$$0(3);
            }
            return "/";
        }
        int firstSlash = fullActionPath.indexOf(47);
        String string = fullActionPath.substring(firstSlash, lastSlash);
        if (string == null) {
            ActionLinkReferenceProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/reference/jsp/ActionLinkReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/reference/jsp/ActionLinkReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createWebPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionLinkPackageReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String namespace;
        private final List<StrutsPackage> allStrutsPackages;
        private final String fullActionPath;

        private ActionLinkPackageReference(PsiElement element, int offset, String text, boolean soft, StrutsModel strutsModel) {
            super(element, ActionLinkPackageReference.computeRange(offset, text), soft);
            this.fullActionPath = PathReference.trimPath((String)text);
            this.namespace = ActionLinkReferenceProvider.getNamespace(this.fullActionPath);
            this.allStrutsPackages = strutsModel.getStrutsPackages();
        }

        private static TextRange computeRange(int offset, String text) {
            int lastSlash = text.lastIndexOf(47);
            return new TextRange(offset, offset + (lastSlash == -1 ? text.length() : lastSlash));
        }

        public PsiElement resolve() {
            for (StrutsPackage strutsPackage : this.allStrutsPackages) {
                if (!Comparing.equal((String)this.namespace, (String)strutsPackage.searchNamespace())) continue;
                return strutsPackage.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array(this.allStrutsPackages, Object.class, strutsPackage -> {
                String packageNamespace = strutsPackage.searchNamespace();
                return LookupElementBuilder.create((String)(packageNamespace.length() != 1 ? packageNamespace + "/" : packageNamespace)).withIcon((Icon)StrutsIcons.STRUTS_PACKAGE).withTypeText(strutsPackage.getName().getStringValue());
            });
            if (objectArray == null) {
                ActionLinkPackageReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve Struts 2 package '" + this.namespace + "'";
            if (string == null) {
                ActionLinkPackageReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/struts2/reference/jsp/ActionLinkReferenceProvider$ActionLinkPackageReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ActionLinkReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final StrutsModel strutsModel;
        private final List<String> actionExtensions;
        private final String fullActionPath;

        private ActionLinkReference(PsiElement element, int offset, String text, boolean soft, StrutsModel strutsModel, List<String> actionExtensions) {
            super(element, new TextRange(offset, offset + text.length()), soft);
            this.strutsModel = strutsModel;
            this.actionExtensions = actionExtensions;
            this.fullActionPath = PathReference.trimPath((String)this.getValue());
            int lastSlash = this.fullActionPath.lastIndexOf("/");
            if (lastSlash != -1) {
                this.setRangeInElement(TextRange.from((int)(offset + lastSlash + 1), (int)(this.fullActionPath.length() - lastSlash - 1)));
            }
            for (String actionExtension : actionExtensions) {
                if (!StringUtil.endsWith((CharSequence)this.fullActionPath, (CharSequence)actionExtension)) continue;
                this.setRangeInElement(TextRange.from((int)this.getRangeInElement().getStartOffset(), (int)(this.getRangeInElement().getLength() - actionExtension.length())));
                break;
            }
        }

        public PsiElement resolve() {
            String namespace;
            String ourActionExtension = (String)ContainerUtil.find(this.actionExtensions, s -> StringUtil.endsWith((CharSequence)this.fullActionPath, (CharSequence)s));
            if (ourActionExtension == null) {
                return null;
            }
            String actionName = ActionLinkReference.getActionName(this.fullActionPath, ourActionExtension);
            List<Action> actions = this.strutsModel.findActionsByName(actionName, namespace = ActionLinkReferenceProvider.getNamespace(this.fullActionPath));
            if (actions.isEmpty()) {
                return null;
            }
            Action myAction = actions.get(0);
            return myAction.getXmlTag();
        }

        @NotNull
        public Object[] getVariants() {
            String namespace = ActionLinkReferenceProvider.getNamespace(this.fullActionPath);
            String firstExtension = this.actionExtensions.get(0);
            List<Action> actionList = this.strutsModel.getActionsForNamespace(namespace);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(actionList.size());
            for (Action action : actionList) {
                String actionPath = action.getName().getStringValue();
                if (actionPath == null) continue;
                variants.add(LookupElementBuilder.create((String)(actionPath + firstExtension)).withIcon(Struts2Icons.Action).withTypeText(action.getNamespace()));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                ActionLinkReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve action '" + this.getValue() + "'";
            if (string == null) {
                ActionLinkReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        private static String getActionName(String fullActionPath, String ourActionExtension) {
            int slashIndex = fullActionPath.lastIndexOf("/");
            int extensionIndex = fullActionPath.lastIndexOf(ourActionExtension);
            String string = fullActionPath.substring(slashIndex + 1, extensionIndex);
            if (string == null) {
                ActionLinkReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/struts2/reference/jsp/ActionLinkReferenceProvider$ActionLinkReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

