/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.intentions.code;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.validator.ValidatorManager;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.Struts2Icons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CreateValidationXmlIntention
extends PsiElementBaseIntentionAction
implements Iconable {
    @NotNull
    public String getText() {
        if ("Create validation.xml" == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(0);
        }
        return "Create validation.xml";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement psiElement) {
        PsiClass clazz;
        if (project == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(2);
        }
        if ((clazz = CreateValidationXmlIntention.findActionClass(psiElement)) == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        if (module == null || StrutsFacet.getInstance(module) == null) {
            return false;
        }
        List<Action> actions = CreateValidationXmlIntention.getActionsForClazz(project, clazz, module);
        if (actions.isEmpty()) {
            return false;
        }
        List<XmlFile> files = ValidatorManager.getInstance(psiElement.getProject()).findValidationFilesFor(clazz);
        return files.isEmpty() || files.size() != actions.size();
    }

    private static List<Action> getActionsForClazz(Project project, PsiClass clazz, Module module) {
        StrutsModel model = StrutsManager.getInstance(project).getCombinedModel(module);
        if (model == null || !model.isActionClass(clazz)) {
            return Collections.emptyList();
        }
        return model.findActionsByClass(clazz);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return Struts2Icons.Action;
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CreateValidationXmlIntention.$$$reportNull$$$0(5);
        }
        final PsiClass actionClass = CreateValidationXmlIntention.findActionClass(element);
        assert (actionClass != null) : element;
        List<Action> filteredActions = CreateValidationXmlIntention.getActionsWithoutValidation(actionClass);
        if (filteredActions.size() > 1) {
            BaseListPopupStep<Action> step = new BaseListPopupStep<Action>("Choose action mapping", filteredActions){

                public Icon getIconFor(Action value) {
                    return Struts2Icons.Action;
                }

                @NotNull
                public String getTextFor(Action value) {
                    String string = value.getName().getStringValue() + " (" + value.getMethod().getStringValue() + ")";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(Action selectedValue, boolean finalChoice) {
                    final String path = selectedValue.getName().getStringValue();
                    new WriteCommandAction<Void>(project, new PsiFile[0]){

                        protected void run(@NotNull Result<Void> result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            CreateValidationXmlIntention.createValidationXml(project, actionClass, path);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/struts2/intentions/code/CreateValidationXmlIntention$1$1", "run"));
                        }
                    }.execute();
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/intentions/code/CreateValidationXmlIntention$1", "getTextFor"));
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
            return;
        }
        CreateValidationXmlIntention.createValidationXml(project, actionClass, filteredActions.get(0).getName().getStringValue());
    }

    private static void createValidationXml(Project project, PsiClass actionClass, @Nullable String path) {
        VirtualFile sourceRoot;
        PsiManager manager = PsiManager.getInstance((Project)project);
        String actionClassQualifiedName = actionClass.getQualifiedName();
        assert (actionClassQualifiedName != null);
        PackageWrapper targetPackage = new PackageWrapper(manager, StringUtil.getPackageName((String)actionClassQualifiedName));
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)actionClass);
        assert (module != null);
        List sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION);
        VirtualFile virtualFile = sourceRoot = sourceRoots.size() == 1 ? (VirtualFile)sourceRoots.get(0) : MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)targetPackage, (List)sourceRoots, (PsiDirectory)manager.findDirectory((VirtualFile)sourceRoots.get(0)));
        if (sourceRoot == null) {
            return;
        }
        PsiDirectory directory = manager.findDirectory(sourceRoot);
        assert (directory != null) : sourceRoot.getPresentableUrl();
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate validationTemplate = templateManager.getJ2eeTemplate("validator.xml");
        PsiDirectory packageDirectoryInSourceRoot = RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)targetPackage, (VirtualFile)sourceRoot);
        try {
            String filename = path == null ? actionClass.getName() + "-validation.xml" : actionClass.getName() + "-" + path + "-validation.xml";
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)validationTemplate, (String)filename, null, (PsiDirectory)packageDirectoryInSourceRoot);
            NavigationUtil.activateFileWithPsiElement((PsiElement)psiElement, (boolean)true);
        }
        catch (Exception e) {
            throw new IncorrectOperationException("error creating validation.xml", (Throwable)e);
        }
    }

    private static List<Action> getActionsWithoutValidation(PsiClass actionClass) {
        Project project = actionClass.getProject();
        List<Action> actions = CreateValidationXmlIntention.getActionsForClazz(project, actionClass, ModuleUtilCore.findModuleForPsiElement((PsiElement)actionClass));
        List<XmlFile> files = ValidatorManager.getInstance(project).findValidationFilesFor(actionClass);
        return ContainerUtil.filter(actions, action -> {
            String path = action.getName().getStringValue();
            for (XmlFile file : files) {
                if (!file.getName().contains(path)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    private static PsiClass findActionClass(PsiElement psiElement) {
        if (!(psiElement instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass clazz = (PsiClass)parent;
        if (clazz.getNameIdentifier() != psiElement) {
            return null;
        }
        if (clazz.isInterface() || clazz.isAnnotationType() || !clazz.hasModifierProperty("public") || clazz.hasModifierProperty("abstract")) {
            return null;
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/intentions/code/CreateValidationXmlIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/intentions/code/CreateValidationXmlIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

