/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph;

import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.components.BasicNodesGroup;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.struts2.graph.beans.ActionNode;
import com.intellij.struts2.graph.beans.BasicStrutsEdge;
import com.intellij.struts2.graph.beans.BasicStrutsNode;
import com.intellij.struts2.graph.beans.ResultNode;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsDataModel
extends GraphDataModel<BasicStrutsNode, BasicStrutsEdge> {
    private final Set<BasicStrutsNode> myNodes = new HashSet();
    private final Set<BasicStrutsEdge> myEdges = new HashSet();
    private final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @NonNls
    private static final String UNKNOWN = "???";

    public StrutsDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
    }

    @NotNull
    public Collection<BasicStrutsNode> getNodes() {
        this.refreshDataModel();
        Set<BasicStrutsNode> set = this.myNodes;
        if (set == null) {
            StrutsDataModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Collection<BasicStrutsEdge> getEdges() {
        Set<BasicStrutsEdge> set = this.myEdges;
        if (set == null) {
            StrutsDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public BasicStrutsNode getSourceNode(BasicStrutsEdge edge) {
        BasicStrutsNode basicStrutsNode = edge.getSource();
        if (basicStrutsNode == null) {
            StrutsDataModel.$$$reportNull$$$0(2);
        }
        return basicStrutsNode;
    }

    @NotNull
    public BasicStrutsNode getTargetNode(BasicStrutsEdge edge) {
        BasicStrutsNode basicStrutsNode = edge.getTarget();
        if (basicStrutsNode == null) {
            StrutsDataModel.$$$reportNull$$$0(3);
        }
        return basicStrutsNode;
    }

    @NotNull
    public String getNodeName(BasicStrutsNode node) {
        String string = node.getName();
        if (string == null) {
            StrutsDataModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getEdgeName(BasicStrutsEdge edge) {
        String string = edge.getName();
        if (string == null) {
            StrutsDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public BasicStrutsEdge createEdge(@NotNull BasicStrutsNode from, @NotNull BasicStrutsNode to) {
        if (from == null) {
            StrutsDataModel.$$$reportNull$$$0(6);
        }
        if (to == null) {
            StrutsDataModel.$$$reportNull$$$0(7);
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.updateDataModel();
    }

    public NodesGroup getGroup(BasicStrutsNode basicStrutsNode) {
        if (this.isGroupElements()) {
            XmlElement xmlElement = basicStrutsNode.getIdentifyingElement().getXmlElement();
            assert (xmlElement != null);
            return this.myGroups.get(xmlElement.getContainingFile());
        }
        return super.getGroup((Object)basicStrutsNode);
    }

    private void addNode(BasicStrutsNode node) {
        if (!node.getIdentifyingElement().isValid()) {
            return;
        }
        this.myNodes.add(node);
        if (this.isGroupElements()) {
            XmlElement element = node.getIdentifyingElement().getXmlElement();
            assert (element != null);
            PsiFile file = element.getContainingFile();
            if (file != null && !this.myGroups.containsKey(file)) {
                String name = file.getName();
                BasicNodesGroup group = new BasicNodesGroup(name){

                    @Nullable
                    public GroupNodeRealizer getGroupNodeRealizer() {
                        GroupNodeRealizer groupNodeRealizer = super.getGroupNodeRealizer();
                        assert (groupNodeRealizer != null);
                        NodeLabel nodeLabel = groupNodeRealizer.getLabel();
                        nodeLabel.setText("      " + this.getGroupName());
                        nodeLabel.setModel(NodeLabel.INTERNAL);
                        nodeLabel.setPosition(NodeLabel.TOP_RIGHT);
                        return groupNodeRealizer;
                    }
                };
                group.setClosed(file != this.myFile);
                this.myGroups.put(file, (NodesGroup)group);
            }
        }
    }

    private boolean isGroupElements() {
        return true;
    }

    private void addEdge(BasicStrutsEdge edge) {
        if (!edge.getSource().getIdentifyingElement().isValid() || !edge.getTarget().getIdentifyingElement().isValid()) {
            return;
        }
        this.myEdges.add(edge);
    }

    private void updateDataModel() {
        StrutsModel model = StrutsManager.getInstance(this.myProject).getModelByFile(this.myFile);
        if (model == null) {
            return;
        }
        for (StrutsPackage strutsPackage : model.getStrutsPackages()) {
            for (Action action : strutsPackage.getActions()) {
                ActionNode actionNode = new ActionNode(action, action.getName().getStringValue());
                this.addNode(actionNode);
                for (Result result : action.getResults()) {
                    PathReference pathReference = (PathReference)result.getValue();
                    String path = pathReference != null ? pathReference.getPath() : UNKNOWN;
                    ResultNode resultNode = new ResultNode(result, path);
                    this.addNode(resultNode);
                    String resultName = result.getName().getStringValue();
                    this.addEdge(new BasicStrutsEdge(actionNode, resultNode, resultName != null ? resultName : "success"));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/graph/StrutsDataModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/graph/StrutsDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

