/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsVersionDetector {
    private StrutsVersionDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String detectStrutsVersion(@NotNull Module module) {
        String string;
        VirtualFile jarRoot;
        if (module == null) {
            StrutsVersionDetector.$$$reportNull$$$0(0);
        }
        if ((jarRoot = StrutsVersionDetector.getStrutsJarRoot(module)) == null) {
            return null;
        }
        VirtualFile entry = jarRoot.findFileByRelativePath("META-INF/maven/org.apache.struts/struts2-core/pom.properties");
        if (entry == null) {
            return null;
        }
        InputStream stream = entry.getInputStream();
        try {
            Properties properties = new Properties();
            properties.load(stream);
            string = properties.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return string;
    }

    @Nullable
    private static VirtualFile getStrutsJarRoot(Module module) {
        VirtualFile classFile;
        PsiFile psiFile;
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass psiClass = facade.findClass("org.apache.struts2.StrutsConstants", scope);
        if (psiClass != null && (psiFile = psiClass.getContainingFile()) != null && (classFile = psiFile.getVirtualFile()) != null && classFile.getFileSystem() instanceof JarFileSystem) {
            return JarFileSystem.getInstance().getRootByEntry(classFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/facet/ui/StrutsVersionDetector", "detectStrutsVersion"));
    }
}

