/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.facet.Facet;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.util.IncorrectOperationException;
import icons.Struts2Icons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class StrutsFileSetCheckingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            StrutsFileSetCheckingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            StrutsFileSetCheckingAnnotator.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof XmlFile)) {
            return;
        }
        if (psiElement instanceof JspFile) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return;
        }
        if (StrutsFacet.getInstance(module) == null) {
            return;
        }
        XmlFile xmlFile = (XmlFile)psiElement;
        Project project = psiElement.getProject();
        StrutsManager strutsManager = StrutsManager.getInstance(project);
        if (!strutsManager.isStruts2ConfigFile(xmlFile)) {
            return;
        }
        VirtualFile currentVirtualFile = xmlFile.getVirtualFile();
        assert (currentVirtualFile != null);
        Set<StrutsFileSet> allConfigFileSets = strutsManager.getAllConfigFileSets(module);
        for (StrutsFileSet configFileSet : allConfigFileSets) {
            if (!configFileSet.hasFile(currentVirtualFile)) continue;
            return;
        }
        boolean fileSetAvailable = allConfigFileSets.size() != 0;
        Annotation annotation = holder.createWarningAnnotation((PsiElement)xmlFile, fileSetAvailable ? StrutsBundle.message("annotators.fileset.file.not.registered", new Object[0]) : StrutsBundle.message("annotators.fileset.no.file.sets", new Object[0]));
        annotation.setFileLevelAnnotation(true);
        if (fileSetAvailable) {
            AddToFileSetFix addToFileSetFix = new AddToFileSetFix(xmlFile.getName());
            annotation.registerFix((IntentionAction)addToFileSetFix);
        } else {
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = StrutsBundle.message("annotators.fileset.edit.facet.settings", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = StrutsBundle.message("intentions.family.name", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    StrutsFacet strutsFacet = StrutsFacet.getInstance(module);
                    assert (strutsFacet != null);
                    ModulesConfigurator.showFacetSettingsDialog((Facet)strutsFacet, null);
                }

                public boolean startInWriteAction() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddToFileSetFix
    extends BaseIntentionAction
    implements Iconable {
        private AddToFileSetFix(String filename) {
            this.setText(StrutsBundle.message("annotators.fileset.fix.add.to.fileset", filename));
        }

        @NotNull
        public String getFamilyName() {
            String string = StrutsBundle.message("intentions.family.name", new Object[0]);
            if (string == null) {
                AddToFileSetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Icon getIcon(int flags) {
            return Struts2Icons.Action;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                AddToFileSetFix.$$$reportNull$$$0(1);
            }
            return true;
        }

        public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                AddToFileSetFix.$$$reportNull$$$0(2);
            }
            StrutsFacet strutsFacet = StrutsFacet.getInstance((PsiElement)file);
            assert (strutsFacet != null);
            Set<StrutsFileSet> strutsFileSets = ((StrutsFacetConfiguration)strutsFacet.getConfiguration()).getFileSets();
            BaseListPopupStep<StrutsFileSet> step = new BaseListPopupStep<StrutsFileSet>(StrutsBundle.message("annotators.fileset.fix.choose.fileset", new Object[0]), new ArrayList<StrutsFileSet>(strutsFileSets)){

                public Icon getIconFor(StrutsFileSet aValue) {
                    return StrutsIcons.STRUTS_CONFIG_FILE;
                }

                public PopupStep onChosen(StrutsFileSet selectedValue, boolean finalChoice) {
                    selectedValue.addFile(file.getVirtualFile());
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
                    });
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    return super.onChosen((Object)selectedValue, finalChoice);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator$AddToFileSetFix$1", "lambda$onChosen$0"));
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator$AddToFileSetFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/struts2/annotators/StrutsFileSetCheckingAnnotator$AddToFileSetFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

