/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.validator.ValidatorManager;
import com.intellij.struts2.facet.StrutsFacet;

public class Struts2ProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project project;

    public Struts2ProblemFileHighlightFilter(Project project) {
        this.project = project;
    }

    public boolean value(VirtualFile virtualFile) {
        if (virtualFile.getFileType() != StdFileTypes.XML) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project);
        if (module == null) {
            return false;
        }
        if (StrutsFacet.getInstance(module) == null) {
            return false;
        }
        boolean isStrutsXml = (Boolean)ReadAction.compute(() -> {
            StrutsManager strutsManager = StrutsManager.getInstance(this.project);
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            return psiFile instanceof XmlFile && strutsManager.isStruts2ConfigFile((XmlFile)psiFile) && strutsManager.getModelByFile((XmlFile)psiFile) != null;
        });
        if (isStrutsXml) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            return psiFile instanceof XmlFile && ValidatorManager.getInstance(this.project).isValidatorsFile((XmlFile)psiFile);
        });
    }
}

