/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AndroidDxRunner {
    @NonNls
    private static final String DEX_MAIN = "com.android.dx.command.dexer.Main";
    @NonNls
    private static final String DEX_CONSOLE = "com.android.dx.command.DxConsole";
    @NonNls
    private static final String DEX_ARGS = "com.android.dx.command.dexer.Main$Arguments";
    @NonNls
    private static final String MAIN_RUN = "run";
    private static Method myMethod;
    private static Constructor<?> myConstructor;
    private static Field myOutNameField;
    private static Field myVerboseField;
    private static Field myForceJumboField;
    private static Field myCoreLibraryField;
    private static Field myJarOutputField;
    private static Field myFileNamesField;
    private static Field myStrictNameCheckField;
    private static Field myOptimizeField;
    private static Field myConsoleOut;
    private static Field myConsoleErr;
    private static Field myMultiDex;
    private static Field myMinimalMainDex;
    private static Field myMainDexList;

    private AndroidDxRunner() {
    }

    private static void loadDex(String dxPath) {
        try {
            File f = new File(dxPath);
            if (!f.isFile()) {
                System.err.println("File not found: " + dxPath);
                return;
            }
            URL url = f.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, AndroidDxRunner.class.getClassLoader());
            Class<?> mainClass = loader.loadClass(DEX_MAIN);
            Class<?> argClass = loader.loadClass(DEX_ARGS);
            myMethod = mainClass.getMethod(MAIN_RUN, argClass);
            myConstructor = argClass.getConstructor(new Class[0]);
            myOutNameField = argClass.getField("outName");
            myJarOutputField = argClass.getField("jarOutput");
            myFileNamesField = argClass.getField("fileNames");
            myVerboseField = argClass.getField("verbose");
            myStrictNameCheckField = argClass.getField("strictNameCheck");
            myForceJumboField = AndroidDxRunner.getFieldIfPossible(argClass, "forceJumbo");
            myCoreLibraryField = AndroidDxRunner.getFieldIfPossible(argClass, "coreLibrary");
            myOptimizeField = AndroidDxRunner.getFieldIfPossible(argClass, "optimize");
            AndroidDxRunner.tryLoadDxConsole(loader);
            myMultiDex = AndroidDxRunner.getFieldIfPossible(argClass, "multiDex");
            myMainDexList = AndroidDxRunner.getFieldIfPossible(argClass, "mainDexListFile");
            myMinimalMainDex = AndroidDxRunner.getFieldIfPossible(argClass, "minimalMainDex");
        }
        catch (SecurityException e) {
            AndroidDxRunner.reportError("Unable to find API for dex.jar", e);
        }
        catch (NoSuchMethodException e) {
            AndroidDxRunner.reportError("Unable to find method for dex.jar", e);
        }
        catch (NoSuchFieldException e) {
            AndroidDxRunner.reportError("Unable to find field for dex.jar", e);
        }
        catch (MalformedURLException e) {
            AndroidDxRunner.reportError("Failed to load dx.jar", e);
        }
        catch (ClassNotFoundException e) {
            AndroidDxRunner.reportError("Failed to load dx.jar", e);
        }
    }

    private static void tryLoadDxConsole(ClassLoader loader) {
        try {
            Class<?> consoleClass = loader.loadClass(DEX_CONSOLE);
            myConsoleOut = consoleClass.getField("out");
            myConsoleErr = consoleClass.getField("err");
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Nullable
    private static Field getFieldIfPossible(Class<?> argClass, String name) {
        try {
            return argClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static int runDex(String dxPath, String outFilePath, String[] fileNames, boolean optimize, boolean forceJumbo, boolean coreLibrary, boolean multiDex, String mainDexList, boolean minimalMainDex) {
        AndroidDxRunner.loadDex(dxPath);
        try {
            if (myConsoleErr != null) {
                myConsoleErr.set(null, System.err);
            }
            if (myConsoleOut != null) {
                myConsoleOut.set(null, System.out);
            }
            Object args = myConstructor.newInstance(new Object[0]);
            myOutNameField.set(args, outFilePath);
            myFileNamesField.set(args, fileNames);
            myJarOutputField.set(args, FileUtilRt.extensionEquals((String)new File(outFilePath).getName(), (String)"jar"));
            myVerboseField.set(args, false);
            myStrictNameCheckField.set(args, false);
            if (myOptimizeField != null) {
                myOptimizeField.set(args, optimize);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'optimize' field. The option won't be passed to DEX");
            }
            if (myForceJumboField != null) {
                myForceJumboField.set(args, forceJumbo);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'forceJumbo' field. The option won't be passed to DEX");
            }
            if (myCoreLibraryField != null) {
                myCoreLibraryField.set(args, coreLibrary);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'coreLibrary' field. The option won't be passed to DEX");
            }
            if (myMultiDex != null) {
                myMultiDex.set(args, multiDex);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'multiDex' field. The option won't be passed to DEX");
            }
            if (myMinimalMainDex != null) {
                myMinimalMainDex.set(args, minimalMainDex);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'minimalMainDex' field. The option won't be passed to DEX");
            }
            if (myMainDexList != null) {
                myMainDexList.set(args, mainDexList);
            } else {
                AndroidDxRunner.reportWarning("Cannot find 'mainDexListFile' field. The option won't be passed to DEX");
            }
            Object res = myMethod.invoke(null, args);
            if (res instanceof Integer) {
                return (Integer)res;
            }
        }
        catch (IllegalAccessException e) {
            AndroidDxRunner.reportError("Unable to execute DX", e);
        }
        catch (InstantiationException e) {
            AndroidDxRunner.reportError("Unable to execute DX", e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            AndroidDxRunner.reportError("Unable to execute DX", targetException != null ? targetException : e);
        }
        return -1;
    }

    private static void reportError(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
    }

    private static void reportWarning(String message) {
        System.err.println("warning: " + message);
    }

    private static void collectFiles(File root, Collection<String> result, Set<String> visited, Set<String> qNames) throws IOException {
        AndroidDxRunner.collectFiles(root.getParentFile(), root, result, visited, qNames);
    }

    private static void collectFiles(File root, File file, Collection<String> result, Set<String> visited, Set<String> qNames) throws IOException {
        String path = file.getCanonicalPath();
        if (!visited.add(path)) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    AndroidDxRunner.collectFiles(root, child, result, visited, qNames);
                }
            }
        } else {
            String qName;
            if (FileUtilRt.extensionEquals((String)file.getName(), (String)"class") && (qName = AndroidDxRunner.getQualifiedName(root, file)) != null && !qNames.add(qName)) {
                AndroidDxRunner.reportWarning(FileUtilRt.toSystemDependentName((String)file.getPath()) + " won't be added. Class " + qName + " already exists in classpath");
                return;
            }
            result.add(path);
        }
    }

    @Nullable
    private static String getQualifiedName(File root, File classFile) {
        String relativePath = FileUtilRt.getRelativePath((File)root, (File)classFile);
        if (relativePath == null) {
            return null;
        }
        return FileUtilRt.getNameWithoutExtension((String)FileUtilRt.toSystemIndependentName((String)relativePath)).replace('/', '.');
    }

    public static void main(String[] args) {
        String arg;
        int i;
        if (args.length == 0) {
            System.err.println("Error: dx path must be passed as first argument");
        }
        String dxPath = args[0];
        if (args.length == 1) {
            System.err.println("Error: out file path must be passed as second argument");
        }
        String outFilePath = args[1];
        if (args.length == 2) {
            System.err.println("Error: no files");
        }
        HashSet<String> files = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> qNames = new HashSet<String>();
        boolean optimize = true;
        boolean forceJumbo = false;
        boolean coreLibrary = false;
        boolean multiDex = false;
        boolean minimalMainDex = false;
        String mainDexList = null;
        for (i = 2; i < args.length && args[i].startsWith("--"); ++i) {
            if ("--optimize".equals(args[i])) {
                if (++i >= args.length) continue;
                optimize = Boolean.parseBoolean(args[i]);
                continue;
            }
            if ("--forceJumbo".equals(args[i])) {
                if (++i >= args.length) continue;
                forceJumbo = Boolean.parseBoolean(args[i]);
                continue;
            }
            if ("--coreLibrary".equals(args[i])) {
                coreLibrary = true;
                continue;
            }
            if ("--multi-dex".equals(args[i])) {
                multiDex = true;
                continue;
            }
            if ("--minimal-main-dex".equals(args[i])) {
                minimalMainDex = true;
                continue;
            }
            if (!"--main-dex-list".equals(args[i]) || ++i >= args.length) continue;
            mainDexList = args[i];
        }
        while (i < args.length && !"--exclude".equals(arg = args[i])) {
            File file = new File(arg);
            if (file.exists()) {
                try {
                    AndroidDxRunner.collectFiles(file, files, visited, qNames);
                }
                catch (IOException e) {
                    AndroidDxRunner.reportError("I/O error", e);
                }
            }
            ++i;
        }
        String[] excludedFiles = new String[args.length - i - 1];
        System.arraycopy(args, i + 1, excludedFiles, 0, excludedFiles.length);
        files.removeAll(Arrays.asList(excludedFiles));
        String[] filesArray = files.toArray(new String[files.size()]);
        AndroidDxRunner.runDex(dxPath, outFilePath, filesArray, optimize, forceJumbo, coreLibrary, multiDex, mainDexList, minimalMainDex);
    }
}

