/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.osgi.Analyzer;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.FakeAnalyzer;

public class LocalPackageCollector {
    private static final String LOCAL_PACKAGES = "{local-packages}";

    public static void addLocalPackages(File outputDirectory, Map<String, String> currentManifest) {
        FakeAnalyzer fakeAnalyzer = new FakeAnalyzer(currentManifest);
        LocalPackageCollector.addLocalPackages(outputDirectory, fakeAnalyzer);
    }

    /*
     * WARNING - void declaration
     */
    private static void addLocalPackages(File outputDirectory, Analyzer analyzer) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        if (outputDirectory != null && outputDirectory.isDirectory()) {
            void var7_10;
            String[] paths;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(outputDirectory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] stringArray = paths = scanner.getIncludedFiles();
            int n = stringArray.length;
            boolean bl = false;
            while (var7_10 < n) {
                String path = stringArray[var7_10];
                packages.add(LocalPackageCollector.getPackageName(path));
                ++var7_10;
            }
        }
        StringBuilder exportedPackages = new StringBuilder();
        StringBuilder privatePackages = new StringBuilder();
        boolean noPrivatePackages = "!*".equals(analyzer.getProperty("Private-Package"));
        for (Object e : packages) {
            String pkg = (String)e;
            if (privatePackages.length() > 0) {
                privatePackages.append(';');
            }
            privatePackages.append(pkg);
            if (!noPrivatePackages && (".".equals(pkg) || pkg.contains(".internal") || pkg.contains(".impl"))) continue;
            if (exportedPackages.length() > 0) {
                exportedPackages.append(';');
            }
            exportedPackages.append(pkg);
        }
        if (analyzer.getProperty("Export-Package") == null) {
            if (analyzer.getProperty("-exportcontents") == null) {
                analyzer.setProperty("Export-Package", exportedPackages + ";-split-package:=merge-first");
            } else {
                analyzer.setProperty("Export-Package", "");
            }
        } else {
            String exported = analyzer.getProperty("Export-Package");
            if (exported.contains(LOCAL_PACKAGES)) {
                String string = StringUtil.replace((String)exported, (String)LOCAL_PACKAGES, (String)exportedPackages.toString());
                analyzer.setProperty("Export-Package", string);
            }
        }
        String internal = analyzer.getProperty("Private-Package");
        if (internal == null) {
            if (privatePackages.length() > 0) {
                analyzer.setProperty("Private-Package", privatePackages + ";-split-package:=merge-first");
            } else {
                analyzer.setProperty("Private-Package", "!*");
            }
        } else if (internal.contains(LOCAL_PACKAGES)) {
            String string = StringUtil.replace((String)internal, (String)LOCAL_PACKAGES, (String)privatePackages.toString());
            analyzer.setProperty("Private-Package", string);
        }
    }

    @NotNull
    private static String getPackageName(@NotNull String filename) {
        int n;
        if (filename == null) {
            LocalPackageCollector.$$$reportNull$$$0(0);
        }
        String string = (n = filename.lastIndexOf(File.separatorChar)) < 0 ? "." : filename.substring(0, n).replace(File.separatorChar, '.');
        if (string == null) {
            LocalPackageCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/build/LocalPackageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/build/LocalPackageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

