/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.service.reporter.Report;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.build.ReportingAnalyzer;
import org.jetbrains.osgi.jps.build.ReportingBuilder;
import org.jetbrains.osgi.jps.build.ReportingProjectBuilder;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.jetbrains.osgi.jps.util.OrderedProperties;

public class BndWrapper {
    private final Reporter myReporter;

    public BndWrapper(Reporter reporter) {
        this.myReporter = reporter;
    }

    @NotNull
    public List<String> bundlifyLibraries(@NotNull Collection<File> dependencies, @NotNull File outputDir, @NotNull List<LibraryBundlificationRule> rules) {
        if (dependencies == null) {
            BndWrapper.$$$reportNull$$$0(0);
        }
        if (outputDir == null) {
            BndWrapper.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            BndWrapper.$$$reportNull$$$0(2);
        }
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)dependencies.size());
        for (File dependency : dependencies) {
            String path = dependency.getPath();
            if (CachingBundleInfoProvider.canBeBundlified(path)) {
                this.myReporter.progress(path);
                try {
                    File bundledDependency = this.wrap(dependency, outputDir, rules);
                    if (bundledDependency == null) continue;
                    result.add(bundledDependency.getPath());
                }
                catch (OsgiBuildException e) {
                    this.myReporter.warning(e.getMessage(), e.getCause(), e.getSourcePath(), -1);
                }
                continue;
            }
            if (!CachingBundleInfoProvider.isBundle(path)) continue;
            result.add(path);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            BndWrapper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private File wrap(@NotNull File sourceFile, @NotNull File outputDir, @NotNull List<LibraryBundlificationRule> rules) throws OsgiBuildException {
        if (sourceFile == null) {
            BndWrapper.$$$reportNull$$$0(4);
        }
        if (outputDir == null) {
            BndWrapper.$$$reportNull$$$0(5);
        }
        if (rules == null) {
            BndWrapper.$$$reportNull$$$0(6);
        }
        if (!sourceFile.isFile()) {
            throw new OsgiBuildException("The library '" + sourceFile + "' does not exist - please check module dependencies.");
        }
        File targetFile = new File(outputDir, sourceFile.getName());
        HashMap additionalProperties = ContainerUtil.newHashMap();
        long lastModified = Long.MIN_VALUE;
        for (LibraryBundlificationRule bundlificationRule : rules) {
            if (!bundlificationRule.appliesTo(sourceFile.getName())) continue;
            if (bundlificationRule.isDoNotBundle()) {
                return null;
            }
            additionalProperties.putAll(bundlificationRule.getAdditionalPropertiesMap());
            lastModified = Math.max(lastModified, bundlificationRule.getLastModified());
            if (!bundlificationRule.isStopAfterThisRule()) continue;
            break;
        }
        if (targetFile.exists() && targetFile.lastModified() >= sourceFile.lastModified() && targetFile.lastModified() >= lastModified) {
            return targetFile;
        }
        this.doWrap(sourceFile, targetFile, additionalProperties);
        return targetFile;
    }

    private void doWrap(@NotNull File inputJar, @NotNull File outputJar, @NotNull Map<String, String> properties) throws OsgiBuildException {
        if (inputJar == null) {
            BndWrapper.$$$reportNull$$$0(7);
        }
        if (outputJar == null) {
            BndWrapper.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            BndWrapper.$$$reportNull$$$0(9);
        }
        if (!FileUtil.delete((File)outputJar)) {
            throw new OsgiBuildException("Can't delete outdated bundle '" + outputJar + "'");
        }
        if (!FileUtil.createParentDirs((File)outputJar)) {
            throw new OsgiBuildException("Can't create output directory for '" + outputJar + "'");
        }
        try (ReportingAnalyzer analyzer = new ReportingAnalyzer(this.myReporter);){
            analyzer.setPedantic(false);
            analyzer.setJar(inputJar);
            analyzer.putAll(properties, false);
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                Matcher m = p.matcher(inputJar.getName());
                if (!m.matches()) {
                    throw new OsgiBuildException("Can't calculate output bundle name for '" + inputJar + "' - rename file or use -properties");
                }
                analyzer.setProperty("Bundle-SymbolicName", m.group(1));
            }
            if (analyzer.getProperty("Export-Package") == null) {
                analyzer.setProperty("Export-Package", "*");
            }
            try (JarFile jarFile = new JarFile(inputJar);){
                analyzer.mergeManifest(jarFile.getManifest());
            }
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Analyzer.cleanupVersion((String)version);
                analyzer.setProperty("Bundle-Version", version);
            }
            analyzer.calcManifest();
            var8_12 = null;
            try (Jar jar = analyzer.getJar();){
                jar.write(outputJar);
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            analyzer.getWarnings().forEach(s -> this.reportProblem((String)s, null, false));
            analyzer.getErrors().forEach(s -> this.reportProblem((String)s, null, true));
        }
        catch (OsgiBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsgiBuildException("There was an unexpected problem when trying to bundlify", e, null);
        }
    }

    public void build(@NotNull Map<String, String> properties, @NotNull File[] classPath, @NotNull File[] srcPath, @NotNull File outputFile) throws Exception {
        if (properties == null) {
            BndWrapper.$$$reportNull$$$0(10);
        }
        if (classPath == null) {
            BndWrapper.$$$reportNull$$$0(11);
        }
        if (srcPath == null) {
            BndWrapper.$$$reportNull$$$0(12);
        }
        if (outputFile == null) {
            BndWrapper.$$$reportNull$$$0(13);
        }
        try (ReportingBuilder builder = new ReportingBuilder(this.myReporter);){
            builder.setProperties(OrderedProperties.fromMap(properties));
            builder.setPedantic(false);
            builder.setClasspath(classPath);
            builder.setSourcepath(srcPath);
            this.doBuild(builder, outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(@NotNull File bndFile, @NotNull File[] classPath, @NotNull File[] srcPath, @NotNull File outputFile) throws Exception {
        block69: {
            Workspace workspace;
            if (bndFile == null) {
                BndWrapper.$$$reportNull$$$0(14);
            }
            if (classPath == null) {
                BndWrapper.$$$reportNull$$$0(15);
            }
            if (srcPath == null) {
                BndWrapper.$$$reportNull$$$0(16);
            }
            if (outputFile == null) {
                BndWrapper.$$$reportNull$$$0(17);
            }
            if ((workspace = Workspace.findWorkspace((File)bndFile)) != null) {
                try (Project project = new Project(workspace, null, bndFile);
                     ProjectBuilder projectBuilder = project.getBuilder(null);){
                    for (Builder sub : projectBuilder.getSubBuilders()) {
                        File source = sub == projectBuilder ? bndFile : sub.getPropertiesFile();
                        String prevSource = this.myReporter.setReportSource(source.getPath());
                        try {
                            ReportingProjectBuilder builder = new ReportingProjectBuilder(this.myReporter, (ProjectBuilder)sub);
                            Throwable throwable = null;
                            try {
                                builder.setProperties(source);
                                File output = sub == projectBuilder ? outputFile : new File(outputFile.getParent(), sub.getBsn() + ".jar");
                                this.doBuild((Builder)builder, output);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (builder == null) continue;
                                if (throwable != null) {
                                    try {
                                        builder.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                builder.close();
                            }
                        }
                        finally {
                            this.myReporter.setReportSource(prevSource);
                        }
                    }
                    break block69;
                }
            }
            try (Builder mainBuilder = new Builder();){
                mainBuilder.setProperties(bndFile);
                mainBuilder.setPedantic(false);
                for (Builder sub : mainBuilder.getSubBuilders()) {
                    File source = sub == mainBuilder ? bndFile : sub.getPropertiesFile();
                    String prevSource = this.myReporter.setReportSource(source.getPath());
                    try {
                        ReportingBuilder builder = new ReportingBuilder(this.myReporter, sub);
                        Throwable throwable = null;
                        try {
                            builder.setProperties(source);
                            builder.setPedantic(false);
                            builder.setClasspath(classPath);
                            builder.setSourcepath(srcPath);
                            File output = sub == mainBuilder ? outputFile : new File(outputFile.getParent(), sub.getBsn() + ".jar");
                            this.doBuild(builder, output);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (builder == null) continue;
                            if (throwable != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            builder.close();
                        }
                    }
                    finally {
                        this.myReporter.setReportSource(prevSource);
                    }
                }
            }
        }
    }

    private void doBuild(@NotNull Builder builder, @NotNull File outputFile) throws Exception {
        File manifestFile;
        String manifest;
        if (builder == null) {
            BndWrapper.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            BndWrapper.$$$reportNull$$$0(19);
        }
        if ((manifest = builder.getProperty("-manifest")) != null && (manifestFile = builder.getFile(manifest)) != null) {
            try (FileInputStream stream = new FileInputStream(manifestFile);){
                Properties p = new Properties();
                p.load(stream);
                String value = p.getProperty(Attributes.Name.MANIFEST_VERSION.toString());
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    String message = "Manifest misses a Manifest-Version entry. This may produce an empty manifest in the resulting bundle.";
                    this.myReporter.warning(message, null, manifest, -1);
                }
            }
            catch (Exception e) {
                this.myReporter.warning("Can't read manifest: " + e.getMessage(), e, manifest, -1);
            }
        }
        try (Jar jar = builder.build();){
            jar.setName(outputFile.getName());
            jar.write(outputFile);
        }
        builder.getWarnings().forEach(s -> {
            if (builder == null) {
                BndWrapper.$$$reportNull$$$0(26);
            }
            this.reportProblem((String)s, builder.getLocation(s), false);
        });
        builder.getErrors().forEach(s -> {
            if (builder == null) {
                BndWrapper.$$$reportNull$$$0(25);
            }
            this.reportProblem((String)s, builder.getLocation(s), true);
        });
    }

    private void reportProblem(String message, Report.Location location, boolean error) {
        String sourcePath = null;
        int lineNum = -1;
        if (location != null) {
            sourcePath = location.file;
            if (location.line > 0) {
                lineNum = location.line + 1;
            }
        }
        if (error) {
            this.myReporter.error(message, null, sourcePath, lineNum);
        } else {
            this.myReporter.warning(message, null, sourcePath, lineNum);
        }
    }

    @NotNull
    public static File getOutputDir(@NotNull File moduleOutputDir) throws OsgiBuildException {
        File outputDir;
        if (moduleOutputDir == null) {
            BndWrapper.$$$reportNull$$$0(20);
        }
        if (!(outputDir = new File(moduleOutputDir.getParent(), "bundles")).exists() && !outputDir.mkdirs()) {
            throw new OsgiBuildException("Can't create output directory '" + outputDir + "'. Please check file permissions.");
        }
        File file = outputDir;
        if (file == null) {
            BndWrapper.$$$reportNull$$$0(21);
        }
        return file;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<String> getBundleNames(@NotNull File bndFile) {
        block25: {
            Throwable throwable;
            Builder builder;
            block22: {
                List<String> list;
                block23: {
                    block24: {
                        if (bndFile == null) {
                            BndWrapper.$$$reportNull$$$0(22);
                        }
                        builder = new Builder();
                        throwable = null;
                        builder.setProperties(bndFile);
                        builder.setPedantic(false);
                        List subs = builder.getSubBuilders();
                        if (subs.size() <= 0 || subs.get(0) == builder) break block22;
                        list = subs.stream().map(sub -> sub.getBsn() + ".jar").collect(Collectors.toList());
                        if (builder == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    builder.close();
                }
                List<String> list2 = list;
                if (list2 == null) {
                    BndWrapper.$$$reportNull$$$0(23);
                }
                return list2;
            }
            try {
                if (builder != null) {
                    if (throwable != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        builder.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (builder != null) {
                                if (throwable != null) {
                                    try {
                                        builder.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    builder.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance(BndWrapper.class).warn((Throwable)e);
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            BndWrapper.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 3: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/build/BndWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputJar";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputJar";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bndFile";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOutputDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/build/BndWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "bundlifyLibraries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDir";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bundlifyLibraries";
                break;
            }
            case 3: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWrap";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getBundleNames";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doBuild$3";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doBuild$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

