/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.javascript.flex.resolve.FlexResolveHelper;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.uml.FlashUmlProvider;
import com.intellij.lang.javascript.uml.FlashUmlVfsResolver;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashUmlElementManager
extends AbstractDiagramElementManager<Object> {
    private final FlashUmlProvider myUmlProvider;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.uml.FlashUmlElementManager");

    public FlashUmlElementManager(FlashUmlProvider umlProvider) {
        this.myUmlProvider = umlProvider;
    }

    public boolean isAcceptableAsNode(Object element) {
        return FlashUmlElementManager.isAcceptableAsNodeStatic(element);
    }

    public static boolean isAcceptableAsNodeStatic(Object element) {
        if (element instanceof JSClass) {
            return true;
        }
        if (element instanceof JSPackageStatement) {
            return true;
        }
        if (element instanceof JSFile) {
            return JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)element)) instanceof JSClass;
        }
        if (element instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            String packageName = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)directory.getVirtualFile(), (Project)directory.getProject());
            return packageName != null && FlashUmlElementManager.packageExists(directory.getProject(), packageName, GlobalSearchScope.allScope((Project)directory.getProject()));
        }
        return false;
    }

    public static boolean packageExists(Project project, String packageName, GlobalSearchScope scope) {
        return JSUtils.packageExists((String)packageName, (GlobalSearchScope)scope) || FlexResolveHelper.mxmlPackageExists(packageName, project, scope);
    }

    public PsiElement findInDataContext(DataContext context) {
        PsiDirectory directory;
        VirtualFile file;
        Project project;
        PsiFile file2;
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (this.isAcceptableAsNode(element)) {
            return element;
        }
        Editor editor = (Editor)LangDataKeys.EDITOR.getData(context);
        if (editor != null && (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            PsiElement elementAtOffset = file2.findElementAt(editor.getCaretModel().getOffset());
            PsiNamedElement enclosing = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, (Class[])new Class[]{JSClass.class, JSFile.class, XmlFile.class});
            if (enclosing instanceof JSClass) {
                element = enclosing;
            } else if (enclosing instanceof JSFile) {
                XmlBackedJSClass clazz = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)enclosing));
                if (clazz != null) {
                    return clazz;
                }
                JSQualifiedNamedElement qualified = JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)enclosing));
                if (qualified instanceof JSClass) {
                    return qualified;
                }
            }
            if (enclosing instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)enclosing))) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)enclosing));
            }
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context)) != null && (directory = PsiManager.getInstance((Project)project).findDirectory(file)) != null && this.isAcceptableAsNode(directory)) {
            return directory;
        }
        return element;
    }

    public PsiElement[] getNodeItems(Object parent) {
        if (parent instanceof JSClass) {
            JSClass clazz = (JSClass)parent;
            if (!clazz.isValid()) {
                return PsiElement.EMPTY_ARRAY;
            }
            ArrayList<JSFunction> elements = new ArrayList<JSFunction>();
            ContainerUtil.addAll(elements, (Object[])clazz.getFields());
            boolean isInterface = clazz.isInterface();
            for (JSFunction method : clazz.getFunctions()) {
                if (isInterface && method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR || method.getKind() == JSFunction.FunctionKind.SETTER && clazz.findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.GETTER) != null) continue;
                elements.add(method);
            }
            if (elements.isEmpty()) {
                return PsiElement.EMPTY_ARRAY;
            }
            if (!(clazz instanceof ActionScriptClassImpl) || clazz.getStub() == null) {
                Collections.sort(elements, (o1, o2) -> o1.getTextOffset() - o2.getTextOffset());
            }
            return PsiUtilCore.toPsiElementArray(elements);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean canCollapse(Object element) {
        return false;
    }

    public boolean isContainerFor(Object parent, Object child) {
        return false;
    }

    public String getElementTitle(Object element) {
        if (element instanceof JSNamedElement) {
            return ((JSNamedElement)element).getName();
        }
        if (element instanceof String) {
            return JSFormatUtil.formatPackage((String)((String)element));
        }
        if (element instanceof JSFile) {
            return JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)element)).getName();
        }
        if (element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) {
            return ((XmlFile)element).getVirtualFile().getNameWithoutExtension();
        }
        return null;
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof JSFunction) {
            return this.getMethodPresentableName((JSFunction)element);
        }
        if (element instanceof JSVariable) {
            return this.getFieldPresentableName((JSVariable)element);
        }
        if (element instanceof JSClass) {
            return this.getClassPresentableName((JSClass)element);
        }
        if (element instanceof String) {
            String s = (String)element;
            return this.decorate(FlashUmlElementManager.getPackageDisplayName(s));
        }
        if (element instanceof JSPackageStatement) {
            return this.decorate(((JSPackageStatement)element).getQualifiedName());
        }
        if (element instanceof JSFile) {
            return this.decorate(this.getElementTitle(element));
        }
        if (element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) {
            return this.decorate(this.getElementTitle(element));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            String qName = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)directory.getVirtualFile(), (Project)directory.getProject());
            return this.decorate(this.getElementTitle(qName));
        }
        return null;
    }

    private static String getPackageDisplayName(String s) {
        return s.length() > 0 ? s : JSBundle.message((String)"top.level", (Object[])new Object[0]);
    }

    private SimpleColoredText decorate(String name) {
        int style = 1;
        SimpleColoredText text = new SimpleColoredText();
        text.append(name, new SimpleTextAttributes(style, this.getFGColor()));
        return text;
    }

    private SimpleColoredText getClassPresentableName(JSClass clazz) {
        int style = 1;
        if (clazz.isDeprecated()) {
            style |= 4;
        }
        if (!clazz.isPhysical()) {
            style |= 2;
        }
        SimpleColoredText text = new SimpleColoredText();
        String name = StringUtil.notNullize((String)clazz.getName());
        text.append(FlashUmlVfsResolver.fixVectorTypeName(name), new SimpleTextAttributes(style, this.getFGColor()));
        return text;
    }

    private SimpleColoredText getMethodPresentableName(JSFunction method) {
        int style = 0;
        if (method.isDeprecated()) {
            style |= 4;
        }
        if (!method.isPhysical()) {
            style |= 2;
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(FlashUmlElementManager.getMethodText(method), new SimpleTextAttributes(style, this.getFGColor()));
        return text;
    }

    private SimpleColoredText getFieldPresentableName(@NotNull JSVariable field) {
        if (field == null) {
            FlashUmlElementManager.$$$reportNull$$$0(0);
        }
        int style = 0;
        if (field.isDeprecated()) {
            style |= 4;
        }
        if (!field.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(FlashUmlElementManager.getFieldText(field), new SimpleTextAttributes(style, this.getFGColor()));
    }

    public static String getMethodText(JSFunction method) {
        return JSFormatUtil.formatMethod((JSFunction)method, (int)257, (int)2);
    }

    public static String getFieldText(JSVariable field) {
        return JSFormatUtil.formatField((JSTypeDeclarationOwner)field, (int)1);
    }

    private Color getFGColor() {
        return this.myUmlProvider.getColorManager().getNodeForegroundColor(false);
    }

    public SimpleColoredText getItemType(Object element) {
        String text = FlashUmlElementManager.getPresentableTypeStatic(element);
        return text != null ? new SimpleColoredText(text, new SimpleTextAttributes(0, this.getFGColor())) : null;
    }

    @Nullable
    public static String getPresentableTypeStatic(Object element) {
        if (element instanceof JSFunction) {
            return JSFormatUtil.formatMethod((JSFunction)((JSFunction)element), (int)2, (int)0);
        }
        if (element instanceof JSVariable) {
            return JSFormatUtil.formatField((JSTypeDeclarationOwner)((JSVariable)element), (int)2);
        }
        return null;
    }

    public String getNodeTooltip(Object element) {
        if (element instanceof JSClass) {
            return "<html><b>" + JSFormatUtil.formatClass((JSClass)((JSClass)element), (int)2048) + "</b></html>";
        }
        return "<html><b>" + FlashUmlElementManager.getPackageDisplayName((String)element) + "</b></html>";
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        return FlashUmlElementManager.getNodeElementIconStatic(element);
    }

    public static Icon getNodeElementIconStatic(Object element) {
        if (element instanceof JSFunction) {
            JSFunction method = (JSFunction)element;
            if (method.getKind() == JSFunction.FunctionKind.GETTER || method.getKind() == JSFunction.FunctionKind.SETTER) {
                Icon propertyIcon = JSFormatUtil.getPropertyIcon((JSFunction)method, (boolean)true);
                return ElementBase.buildRowIcon((Icon)propertyIcon, (Icon)method.getAttributeList().getAccessType().getIcon());
            }
            if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
                return ElementBase.buildRowIcon((Icon)JSFunctionImpl.CONSTRUCTOR_ICON, (Icon)method.getAttributeList().getAccessType().getIcon());
            }
        }
        return element instanceof Iconable ? ((Iconable)element).getIcon(0) : PlatformIcons.ERROR_INTRODUCTION_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/uml/FlashUmlElementManager", "getFieldPresentableName"));
    }
}

