/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ActionScriptPropertyFunctionRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            ActionScriptPropertyFunctionRenameProcessor.$$$reportNull$$$0(0);
        }
        return DialectDetector.isActionScript((PsiElement)element) && (element instanceof JSVariable || JSGetterSetterRenameUtil.isGetterSetterFunction((PsiElement)element));
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)element);
        if (containingClass != null) {
            allRenames.putAll(JSGetterSetterRenameUtil.getRelatedElementsInClass((PsiElement)element, (JSClass)containingClass, (String)newName));
            if (element instanceof JSVariable) {
                String name = ((JSVariable)element).getName();
                JSResolveUtil.processHierarchy((JSClass)containingClass, aClass -> {
                    JSFunction setter;
                    if (!aClass.isInterface()) {
                        return true;
                    }
                    JSFunction getter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
                    if (getter != null) {
                        allRenames.put((PsiElement)getter, newName);
                    }
                    if ((setter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SETTER)) != null) {
                        allRenames.put((PsiElement)setter, newName);
                    }
                    return true;
                }, (boolean)true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/ActionScriptPropertyFunctionRenameProcessor", "canProcessElement"));
    }
}

