/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.ActionScriptIndentOptionsEditor;
import com.intellij.lang.javascript.formatter.ECMA4CodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ActionScriptLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final String GENERAL_CODE_SAMPLE = "package {\nclass Foo {\npublic function foo(x:int, z) {\nvar arr = [\"zero\", \"one\"];\nvar x = {0:\"zero\", 1:\"one\"};\nvar y = (x ^ 0x123) << 2;\nvar k = x > 15 ? 1 : 2;\ndo {\ntry {\nif (0 < x && x < 10) {\nwhile (x != y) {\nx = f(x * 3 + 5);\n}\nz += 2;\n} else if (x > 20) {\nz = x << 1;\n} else {\nz = x | 2;\n}\nswitch (k) {\ncase 0:\nvar s1 = 'zero';\nbreak;\ncase 2:\nvar s1 = 'two';\nbreak;\ndefault:\nvar s1 = 'other';\n}\n} catch (e:Exception) {\nvar message = arr[0];\n}\n} while (x < 0);\n}\n\n    function sum(...args) {\n        for (var i:uint = 0; i < args.length; i++) {\n            trace(args[i]);\n        }\n    }\n}\n}";
    public static final String WRAPPING_CODE_SAMPLE = "function buzz() { return 0; }\n\nclass Foo {\n\nnumbers : ['one', 'two', 'three', 'four', 'five', 'six'];\n\n// function fBar (x,y);\nfunction fOne(argA, argB, argC, argD, argE, argF, argG, argH) {\nx = argA + argB + argC + argD + argE + argF + argG + argH;\nthis.fTwo(argA, argB, argC, this.fThree(argD, argE, argF, argG, argH));\nvar z = argA == 'Some string' ? 'yes' : 'no';\nvar colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\nfor (var colorIndex = 0; colorIndex < colors.length; colorIndex++) \nvar colorString = this.numbers[colorIndex];\n}\n\nfunction fTwo(strA, strB, strC, strD) {\nif (true)\nreturn strC;\nif (strA == 'one' || \nstrB == 'two' || strC == 'three') {\nreturn strA + strB + strC;\n} else return strD\nreturn strD;\n}\n\nfunction fThree(strA, strB, strC, strD, strE) {\nreturn strA + strB + strC + strD + strE;\n}\n/*\n Multiline\n   C-style\n     Comment\n */\nfunction fFour() {\n    var myLinkText = \"Button\",\n            local = true,\n            initial = -1;\n    var cssClasses = [\"bold\", \"red\",]\n    var selector = \"#id\";\n\n    var color = \"red\";\n    var offset = 10;\n    }}";
    public static final String BLANK_LINE_CODE_SAMPLE = "package {\nimport com.jetbrains.flex.Demo;\nimport com.jetbrains.flex.Sample;\nclass Foo {\n    var demo : Demo;\n    var sample : Sample;\n    public function foo(x:int, z) {\n        var y = x * z;\n\n\n        return y;\n    }\n    public function getSample() {\n        return sample;\n    }\n}\n\n}";
    public static final String INDENT_CODE_SAMPLE = "package {\nclass Foo {\n    public function foo(x:int, z) {\n        var y = x * z;\n\n\n        return y;\n    }\n}\n}";

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (jSLanguageDialect == null) {
            ActionScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return jSLanguageDialect;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new ActionScriptIndentOptionsEditor();
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            ActionScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        switch (settingsType) {
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return BLANK_LINE_CODE_SAMPLE;
            }
            case SPACING_SETTINGS: {
                return GENERAL_CODE_SAMPLE;
            }
            case LANGUAGE_SPECIFIC: {
                return GENERAL_CODE_SAMPLE;
            }
            case INDENT_SETTINGS: {
                return INDENT_CODE_SAMPLE;
            }
        }
        return GENERAL_CODE_SAMPLE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            ActionScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            ActionScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(JSLanguageCodeStyleSettingsProvider.STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACE_BEFORE_PROPERTY_COLON", JSBundle.message((String)"space.before.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACE_AFTER_PROPERTY_COLON", JSBundle.message((String)"space.after.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACE_AFTER_DOTS_IN_REST_PARAMETER", JSBundle.message((String)"space.after.dots.in.rest.parameter", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_FUNCTION_LEFT_PARENTH", JSBundle.message((String)"space.before.function.left.parenth", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JSBundle.message((String)"space.before.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JSBundle.message((String)"space.after.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "SPACES_WITHIN_OBJECT_LITERAL_BRACES", JSBundle.message((String)"spaces.within.object.literal.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            ArrayList<String> blankLinesOptions = new ArrayList<String>();
            blankLinesOptions.addAll(Arrays.asList("KEEP_BLANK_LINES_IN_CODE", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AROUND_METHOD", "KEEP_BLANK_LINES_IN_CODE", "BLANK_LINES_BEFORE_PACKAGE", "BLANK_LINES_AFTER_PACKAGE"));
            consumer.showStandardOptions(ArrayUtil.toStringArray(blankLinesOptions));
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "BLANK_LINES_AROUND_FUNCTION", JSBundle.message((String)"js.blank.lines.around.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            ArrayList<String> wrappingOptions = new ArrayList<String>();
            wrappingOptions.addAll(Arrays.asList(JSLanguageCodeStyleSettingsProvider.STANDARD_WRAPPING_OPTIONS));
            wrappingOptions.addAll(Arrays.asList("CLASS_BRACE_STYLE", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP"));
            consumer.showStandardOptions(ArrayUtil.toStringArray(wrappingOptions));
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.after.left.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.before.right.bracket", (Object[])new Object[0]));
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "FUNCTION_EXPRESSION_BRACE_STYLE", JSBundle.message((String)"js.function.expression.brace.style", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "METHOD_BRACE_STYLE", new Object[]{CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES});
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "REFORMAT_C_STYLE_COMMENTS", JSBundle.message((String)"js.format.cstyle.comments", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_COMMENTS, new Object[0]);
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "OBJECT_LITERAL_WRAP", "Object literals", null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "ALIGN_OBJECT_PROPERTIES", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]), new Object[]{JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_OPTIONS, JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_VALUES});
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "VAR_DECLARATION_WRAP", JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]), null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(ECMA4CodeStyleSettings.class, "ALIGN_VAR_STATEMENTS", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]), new Object[]{JSLanguageCodeStyleSettingsProvider.ALIGN_VAR_STATEMENT_OPTIONS, JSLanguageCodeStyleSettingsProvider.ALIGN_VAR_STATEMENT_VALUES});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
        }
    }

    protected String getPreviewText() {
        return "/*\n Multiline\n C-style\n Comment\n */\nvar myLink = {\n      img: \"btn.gif\",\n      text: \"Button\",\n      width: 128\n    },\n    local = true,\n    initial = -1;\nvar cssClasses = [\"bold\", \"red\",]\nvar selector = \"#id\";\n\nvar color = \"red\";\nvar offset = 10;\n\nvarName = val;";
    }

    public String getFileExt() {
        return "as";
    }

    public String getLanguageName() {
        return "ActionScript";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonSettings = new CommonCodeStyleSettings(this.getLanguage());
        commonSettings.BLANK_LINES_AFTER_PACKAGE = 0;
        commonSettings.initIndentOptions();
        return commonSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/ActionScriptLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/ActionScriptLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

