/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.RepeatableValueDialog;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.ui.JSClassChooserDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class RLMsDialog
extends RepeatableValueDialog {
    private final Module myModule;

    public RLMsDialog(Module module, Collection<FlexBuildConfiguration.RLMInfo> rlms) {
        super(module.getProject(), FlexBundle.message("rlms.dialog.title", new Object[0]), RLMsDialog.toStringBuilderList(rlms), CompilerOptionInfo.RLMS_INFO_FOR_UI);
        this.myModule = module;
        this.setEditAddedRow(false);
        this.myTable.getColumnModel().getColumn(0).setCellRenderer(RLMsDialog.createMainClassRenderer(module));
        this.myTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)RLMsDialog.createMainClassEditor(module));
    }

    private static List<StringBuilder> toStringBuilderList(Collection<FlexBuildConfiguration.RLMInfo> rlms) {
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        for (FlexBuildConfiguration.RLMInfo rlm : rlms) {
            result.add(new StringBuilder().append(rlm.MAIN_CLASS).append("\t").append(rlm.OUTPUT_FILE).append("\t").append(rlm.OPTIMIZE));
        }
        return result;
    }

    private static DefaultTableCellRenderer createMainClassRenderer(final Module module) {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String fqn = String.valueOf(value);
                this.setText(fqn);
                this.setForeground((Color)(isSelected ? table.getSelectionForeground() : (FlexUtils.getPathToMainClassFile(fqn, module).isEmpty() ? JBColor.RED : table.getForeground())));
                return component;
            }
        };
    }

    private static AbstractTableCellEditor createMainClassEditor(final Module module) {
        return new AbstractTableCellEditor(){
            private JSReferenceEditor mainClassComponent;

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.mainClassComponent = JSReferenceEditor.forClassName((String)"", (Project)module.getProject(), null, (GlobalSearchScope)module.getModuleScope(false), null, null, (String)FlexBundle.message("choose.rlm.main.class.title", new Object[0]));
                this.mainClassComponent.setText(String.valueOf(value));
                return this.mainClassComponent;
            }

            public Object getCellEditorValue() {
                return this.mainClassComponent.getText();
            }
        };
    }

    @Override
    protected boolean addObject() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return super.addObject();
        }
        JSClassChooserDialog chooser = new JSClassChooserDialog(this.myProject, FlexBundle.message("choose.rlm.main.class.title", new Object[0]), this.myModule.getModuleScope(false), null, null);
        if (chooser.showDialog()) {
            JSClass clazz = chooser.getSelectedClass();
            if (clazz != null) {
                StringBuilder b = new StringBuilder();
                b.append(clazz.getQualifiedName());
                b.append("\t");
                b.append(BCUtils.suggestRLMOutputPath(clazz.getQualifiedName()));
                b.append("\t");
                b.append("true");
                this.getCurrentList().add(b);
                return true;
            }
            return false;
        }
        return false;
    }

    public Collection<FlexBuildConfiguration.RLMInfo> getRLMs() {
        List currentList = this.getCurrentList();
        ArrayList<FlexBuildConfiguration.RLMInfo> result = new ArrayList<FlexBuildConfiguration.RLMInfo>(currentList.size());
        for (StringBuilder listEntry : currentList) {
            List parts = StringUtil.split((String)listEntry.toString(), (String)"\t", (boolean)true, (boolean)false);
            assert (parts.size() == 3) : listEntry;
            result.add(new FlexBuildConfiguration.RLMInfo((String)parts.get(0), (String)parts.get(1), Boolean.valueOf((String)parts.get(2))));
        }
        return result;
    }

    protected String getHelpId() {
        return "Runtime-Loaded_Modules_dialog";
    }
}

