/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class AirDescriptorForm {
    private JPanel myMainPanel;
    private JRadioButton myGeneratedDescriptorRadioButton;
    private JRadioButton myCustomDescriptorRadioButton;
    private TextFieldWithBrowseButton myCustomDescriptorTextWithBrowse;
    private JButton myCreateDescriptorButton;

    public AirDescriptorForm(final Project project, final Runnable descriptorCreator) {
        this.$$$setupUI$$$();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirDescriptorForm.this.updateControls();
                if (AirDescriptorForm.this.myCustomDescriptorRadioButton.isSelected()) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)AirDescriptorForm.this.myCustomDescriptorTextWithBrowse.getTextField(), true);
                }
            }
        };
        this.myGeneratedDescriptorRadioButton.addActionListener(listener);
        this.myCustomDescriptorRadioButton.addActionListener(listener);
        this.myCustomDescriptorTextWithBrowse.addBrowseFolderListener(null, null, project, FlexUtils.createFileChooserDescriptor("xml"));
        this.myCreateDescriptorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                descriptorCreator.run();
            }
        });
    }

    void updateControls() {
        this.myCustomDescriptorTextWithBrowse.setEnabled(this.myCustomDescriptorRadioButton.isEnabled() && this.myCustomDescriptorRadioButton.isSelected());
        this.myCreateDescriptorButton.setEnabled(this.myCustomDescriptorRadioButton.isEnabled() && this.myCustomDescriptorRadioButton.isSelected());
    }

    public void resetFrom(AirPackagingOptions packagingOptions) {
        this.myGeneratedDescriptorRadioButton.setSelected(packagingOptions.isUseGeneratedDescriptor());
        this.myCustomDescriptorRadioButton.setSelected(!packagingOptions.isUseGeneratedDescriptor());
        this.myCustomDescriptorTextWithBrowse.setText(FileUtil.toSystemDependentName((String)packagingOptions.getCustomDescriptorPath()));
    }

    public boolean isModified(ModifiableAirPackagingOptions packagingOptions) {
        if (packagingOptions.isUseGeneratedDescriptor() != this.myGeneratedDescriptorRadioButton.isSelected()) {
            return true;
        }
        return !packagingOptions.getCustomDescriptorPath().equals(FileUtil.toSystemIndependentName((String)this.myCustomDescriptorTextWithBrowse.getText().trim()));
    }

    public void applyTo(ModifiableAirPackagingOptions model) {
        model.setUseGeneratedDescriptor(this.myGeneratedDescriptorRadioButton.isSelected());
        model.setCustomDescriptorPath(FileUtil.toSystemIndependentName((String)this.myCustomDescriptorTextWithBrowse.getText().trim()));
    }

    public void setUseCustomDescriptor(String descriptorPath) {
        this.myCustomDescriptorRadioButton.setSelected(true);
        this.myCustomDescriptorTextWithBrowse.setText(FileUtil.toSystemDependentName((String)descriptorPath));
        this.updateControls();
    }

    public ActionCallback navigateTo(AirPackagingConfigurableBase.Location location) {
        if (location == AirPackagingConfigurableBase.Location.CustomDescriptor) {
            return IdeFocusManager.findInstance().requestFocus((Component)this.myCustomDescriptorTextWithBrowse.getChildComponent(), true);
        }
        return ActionCallback.DONE;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Application descriptor", (int)0, (int)0, null, null));
        this.myCustomDescriptorRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Custom template:");
        jRadioButton2.setMnemonic('C');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomDescriptorTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGeneratedDescriptorRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Generated");
        jRadioButton.setMnemonic('G');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreateDescriptorButton = jButton = new JButton();
        jButton.setText("Create...");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

