/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.detection;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexModuleSourceRoot;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexProjectStructureDetector;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.Nullable;

public class FlexModuleInsight
extends ModuleInsight {
    public FlexModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        super(progress, existingModuleNames, existingProjectLibraryNames);
    }

    protected ModuleDescriptor createModuleDescriptor(File moduleContentRoot, Collection<DetectedSourceRoot> sourceRoots) {
        return new ModuleDescriptor(moduleContentRoot, (ModuleType)FlexModuleType.getInstance(), sourceRoots);
    }

    protected boolean isSourceFile(File file) {
        return FlexProjectStructureDetector.isActionScriptFile(file);
    }

    protected void scanSourceFileForImportedPackages(CharSequence chars, Consumer<String> result) {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)).createLexer(null);
        lexer.start(chars);
        if (FlexProjectStructureDetector.readPackageName(chars, lexer) == null) {
            return;
        }
        while (true) {
            String s;
            if (lexer.getTokenType() != null && lexer.getTokenType() != JSTokenTypes.IMPORT_KEYWORD) {
                lexer.advance();
                continue;
            }
            if (lexer.getTokenType() == null) break;
            lexer.advance();
            FlexProjectStructureDetector.skipWhiteSpaceAndComments(lexer);
            String packageName = FlexProjectStructureDetector.readQualifiedName(chars, lexer, true);
            if (packageName == null || (s = packageName.endsWith(".*") ? StringUtil.trimEnd((String)packageName, (String)".*") : StringUtil.getPackageName((String)packageName)).isEmpty()) continue;
            result.consume((Object)s);
        }
    }

    protected boolean isLibraryFile(String fileName) {
        return fileName.toLowerCase().endsWith(".swc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanLibraryForDeclaredPackages(File file, final Consumer<String> result) throws IOException {
        FileInputStream in = null;
        try {
            ZipEntry e;
            in = new FileInputStream(file);
            ZipInputStream zip = new ZipInputStream(in);
            while ((e = zip.getNextEntry()) != null) {
                if (e.isDirectory() || !"catalog.xml".equals(e.getName())) continue;
                InputStreamReader reader = new InputStreamReader((InputStream)zip, "UTF-8");
                NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                    private boolean processingDef;

                    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                        if (name.equals("def")) {
                            this.processingDef = true;
                        }
                    }

                    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                        if (name.equals("def")) {
                            this.processingDef = false;
                        }
                    }

                    public void addAttribute(String name, String nsPrefix, String nsURI, String value, String type) throws Exception {
                        String fqn;
                        String packageName;
                        if (this.processingDef && name.equals("id") && !(packageName = StringUtil.getPackageName((String)(fqn = value.replace(':', '.')))).isEmpty()) {
                            result.consume((Object)packageName);
                        }
                    }
                });
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isApplicableRoot(DetectedProjectRoot root) {
        return root instanceof FlexModuleSourceRoot;
    }
}

