/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.ByteBuffer;
import com.intellij.lang.javascript.flex.importer.FlexByteCodeInformationProcessor;
import org.jetbrains.annotations.NonNls;

class Swf {
    private final FlexByteCodeInformationProcessor processor;
    private int bitPos;
    private int bitBuf;
    private final ByteBuffer data;
    private static final int stagDoABC = 72;
    private static final int stagDoABC2 = 82;
    @NonNls
    private static final String[] tagNames = new String[]{"End", "ShowFrame", "DefineShape", "FreeCharacter", "PlaceObject", "RemoveObject", "DefineBits", "DefineButton", "JPEGTables", "SetBackgroundColor", "DefineFont", "DefineText", "DoAction", "DefineFontInfo", "DefineSound", "StartSound", "StopSound", "DefineButtonSound", "SoundStreamHead", "SoundStreamBlock", "DefineBitsLossless", "DefineBitsJPEG2", "DefineShape2", "DefineButtonCxform", "Protect", "PathsArePostScript", "PlaceObject2", "27 (invalid)", "RemoveObject2", "SyncFrame", "30 (invalid)", "FreeAll", "DefineShape3", "DefineText2", "DefineButton2", "DefineBitsJPEG3", "DefineBitsLossless2", "DefineEditText", "DefineVideo", "DefineSprite", "NameCharacter", "ProductInfo", "DefineTextFormat", "FrameLabel", "DefineBehavior", "SoundStreamHead2", "DefineMorphShape", "FrameTag", "DefineFont2", "GenCommand", "DefineCommandObj", "CharacterSet", "FontRef", "DefineFunction", "PlaceFunction", "GenTagObject", "ExportAssets", "ImportAssets", "EnableDebugger", "DoInitAction", "DefineVideoStream", "VideoFrame", "DefineFontInfo2", "DebugID", "EnableDebugger2", "ScriptLimits", "SetTabIndex", "DefineShape4", "68 (invalid)", "FileAttributes", "PlaceObject3", "ImportAssets2", "DoABC", "DefineFontAlignZones", "CSMTextSettings", "DefineFont3", "SymbolClass", "Metadata", "ScalingGrid", "79 (invalid)", "80 (invalid)", "81 (invalid)", "DoABC2", "DefineShape4", "DefineMorphShape2", "85 (invalid)", "DefineSceneAndFrameLabelData", "DefineBinaryData", "DefineFontName", "89 (unknown)  ", "90 (unknown)  ", "DefineFont4", "(invalid)"};

    public Swf(ByteBuffer _data, FlexByteCodeInformationProcessor _processor) {
        this.data = _data;
        this.processor = _processor;
        Rect rect = this.decodeRect();
        int rate = this.data.readUnsignedByte() << 8 | this.data.readUnsignedByte();
        int count = this.data.readUnsignedShort();
        this.processor.dumpStat("size " + rect + "\n");
        this.processor.dumpStat("frame rate " + rate + "\n");
        this.processor.dumpStat("frame count " + count + "\n");
        this.decodeTags();
    }

    private void decodeTags() {
        block5: while (this.data.getPosition() < this.data.bytesSize()) {
            int h = this.data.readUnsignedShort();
            int type = h >> 6;
            int length = h & 0x3F;
            if (length == 63) {
                length = this.data.readInt();
            }
            this.processor.dumpStat((type < tagNames.length ? tagNames[type] : "undefined") + " " + length + "b " + 100 * length / this.data.bytesSize() + "%\n");
            switch (type) {
                case 0: {
                    return;
                }
                case 82: {
                    int pos1 = this.data.getPosition();
                    this.data.readInt();
                    String abcName = this.readString();
                    this.processor.dumpStat("\nabc name " + abcName + "\n");
                    length -= this.data.getPosition() - pos1;
                }
                case 72: {
                    ByteBuffer data2 = new ByteBuffer();
                    data2.setLittleEndian();
                    this.data.readBytes(data2, length);
                    new Abc(data2, this.processor).dump(this.processor.getAbcInSwfIndent());
                    this.processor.append("\n");
                    continue block5;
                }
            }
            this.data.incPosition(length);
        }
    }

    private String readString() {
        int c;
        String s = "";
        while ((c = this.data.readUnsignedByte()) != 0) {
            s = s + (char)c;
        }
        return s;
    }

    private void syncBits() {
        this.bitPos = 0;
    }

    private Rect decodeRect() {
        this.syncBits();
        Rect rect = new Rect();
        int nBits = this.readUBits(5);
        rect.xMin = this.readSBits(nBits);
        rect.xMax = this.readSBits(nBits);
        rect.yMin = this.readSBits(nBits);
        rect.yMax = this.readSBits(nBits);
        return rect;
    }

    int readSBits(int numBits) {
        if (numBits > 32) {
            throw new Error("Number of bits > 32");
        }
        int num = this.readUBits(numBits);
        int shift = 32 - numBits;
        num = num << shift >> shift;
        return num;
    }

    int readUBits(int numBits) {
        int shift;
        if (numBits == 0) {
            return 0;
        }
        int bitsLeft = numBits;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.data.readUnsignedByte();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.data.readUnsignedByte();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private static class Rect {
        int nBits;
        int xMin;
        int xMax;
        int yMin;
        int yMax;

        private Rect() {
        }

        @NonNls
        public String toString() {
            return "[Rect " + this.xMin + " " + this.yMin + " " + this.xMax + " " + this.yMax + "]";
        }
    }
}

