/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.AbstractDumpProcessor;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AbcDumper
extends AbstractDumpProcessor {
    private final boolean dumpCode;

    public AbcDumper(boolean _dumpCode) {
        this.dumpCode = _dumpCode;
    }

    @Override
    public void dumpStat(@NotNull String stat) {
        if (stat == null) {
            AbcDumper.$$$reportNull$$$0(0);
        }
        this.sb.append(stat);
    }

    @Override
    public void hasError(@NotNull String error) {
        if (error == null) {
            AbcDumper.$$$reportNull$$$0(1);
        }
        this.sb.append(error);
    }

    @Override
    protected String appendModifiers(MemberInfo member, String attr) {
        attr = attr + (member instanceof MethodInfo && (((MethodInfo)member).flags & 0x20) != 0 ? "native " : "");
        return attr;
    }

    @Override
    public void processMultinameAsPackageName(@NotNull Multiname name, @Nullable String parentName) {
        if (name == null) {
            AbcDumper.$$$reportNull$$$0(2);
        }
        this.append(name.hasNotEmptyNs() ? name.getValidNsName(this.classNameTable) + "::" + name.name : name.name);
    }

    @Override
    public void dumpToplevelAnonymousMethod(@NotNull Abc abc, @NotNull MethodInfo m) {
        if (abc == null) {
            AbcDumper.$$$reportNull$$$0(3);
        }
        if (m == null) {
            AbcDumper.$$$reportNull$$$0(4);
        }
        m.dump(abc, "", "", this);
    }

    @Override
    public void dumpTopLevelTraits(Abc abc, @NotNull Traits t, String indent) {
        if (t == null) {
            AbcDumper.$$$reportNull$$$0(5);
        }
        this.sb.append(indent + t.name + "\n");
        t.dump(abc, indent, "", this);
        t.init.dump(abc, indent, "", this);
    }

    @Override
    public boolean doDumpMember(@NotNull MemberInfo memberInfo) {
        if (memberInfo == null) {
            AbcDumper.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public void appendMethodSeparator() {
        this.append("\n");
    }

    @Override
    public void appendFieldSeparator() {
        this.append("");
    }

    @Override
    public String getAbcInSwfIndent() {
        return "  ";
    }

    @Override
    public void processValue(Multiname type, Object value) {
        this.append(" = " + String.valueOf(value instanceof String ? '\"' + value.toString() + '\"' : value));
    }

    @Override
    public boolean doDumpMetaData(@NotNull MetaData md) {
        if (md == null) {
            AbcDumper.$$$reportNull$$$0(7);
        }
        return true;
    }

    @Override
    public void processParameter(@NotNull String name, @Nullable Multiname type, String parentName, @Nullable Multiname value, boolean rest) {
        if (name == null) {
            AbcDumper.$$$reportNull$$$0(8);
        }
        this.processMultinameAsPackageName(type, parentName);
    }

    @Override
    public boolean doStarTypeDumpInExtends() {
        return true;
    }

    @Override
    public boolean doStarMetaAttrNameDump() {
        return true;
    }

    @Override
    public void setProcessingInterface(boolean anInterface) {
    }

    @Override
    protected boolean dumpRestParameter() {
        return false;
    }

    @Override
    public void processFunction(MethodInfo methodInfo, boolean referenceNameRequested, Abc abc, String indent, String attr) {
        super.processFunction(methodInfo, referenceNameRequested, abc, indent, attr);
        this.append("\t/* disp_id " + methodInfo.id + "*/");
        if (!referenceNameRequested) {
            this.append("\n");
            if (this.dumpCode && methodInfo.code != null) {
                methodInfo.dumpCode(abc, indent, this);
            }
        }
    }

    @Override
    public void processVariable(SlotInfo info, String indent, String attr) {
        super.processVariable(info, indent, attr);
        this.append("\t/* slot_id " + info.id + " */\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stat";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "md";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/importer/AbcDumper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpStat";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMultinameAsPackageName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpToplevelAnonymousMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpTopLevelTraits";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doDumpMember";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doDumpMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

