/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitClassInspectionBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitClassInProductSourceInspection
extends FlexUnitClassInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testclassinproductsource.displayname", new Object[0]);
        if (string == null) {
            FlexUnitClassInProductSourceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitClassInProductSourceInspection" == null) {
            FlexUnitClassInProductSourceInspection.$$$reportNull$$$0(1);
        }
        return "FlexUnitClassInProductSourceInspection";
    }

    @Override
    protected void visitPotentialTestClass(JSClass aClass, @NotNull ProblemsHolder holder, FlexUnitSupport support) {
        PsiElement nameIdentifier;
        VirtualFile file;
        if (holder == null) {
            FlexUnitClassInProductSourceInspection.$$$reportNull$$$0(2);
        }
        if ((file = aClass.getContainingFile().getVirtualFile()) == null) {
            return;
        }
        if (!ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInTestSourceContent(file) && (nameIdentifier = aClass.getNameIdentifier()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MoveClassFix();
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem(nameIdentifier, FlexBundle.message("flexunit.inspection.testclassinproductsource.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPotentialTestClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MoveClassFix
    implements RefactoringQuickFix {
        private MoveClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Move class" == null) {
                MoveClassFix.$$$reportNull$$$0(0);
            }
            return "Move class";
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
            if (refactoringActionHandler == null) {
                MoveClassFix.$$$reportNull$$$0(1);
            }
            return refactoringActionHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHandler";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

