/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexRefactoringListenerProvider;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfigurationForm;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.run.FlexRunConfigRefactoringListener;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FlexUnitRunConfiguration
extends LocatableConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption,
RefactoringListenerProvider {
    private FlexUnitRunnerParameters myRunnerParameters = new FlexUnitRunnerParameters();

    protected FlexUnitRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        FlexUnitRunConfigurationForm flexUnitRunConfigurationForm = new FlexUnitRunConfigurationForm(this.getProject());
        if (flexUnitRunConfigurationForm == null) {
            FlexUnitRunConfiguration.$$$reportNull$$$0(0);
        }
        return flexUnitRunConfigurationForm;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = new FlexUnitRunnerParameters();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public FlexUnitRunConfiguration clone() {
        FlexUnitRunConfiguration clone = (FlexUnitRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    @NotNull
    public FlexUnitRunnerParameters getRunnerParameters() {
        FlexUnitRunnerParameters flexUnitRunnerParameters = this.myRunnerParameters;
        if (flexUnitRunnerParameters == null) {
            FlexUnitRunConfiguration.$$$reportNull$$$0(1);
        }
        return flexUnitRunnerParameters;
    }

    public String suggestedName() {
        switch (this.myRunnerParameters.getScope()) {
            case Class: {
                return StringUtil.getShortName((String)this.myRunnerParameters.getClassName());
            }
            case Method: {
                return StringUtil.getShortName((String)this.myRunnerParameters.getClassName()) + "." + this.myRunnerParameters.getMethodName() + "()";
            }
            case Package: {
                return StringUtil.isEmpty((String)this.myRunnerParameters.getPackageName()) ? this.myRunnerParameters.getModuleName() : this.myRunnerParameters.getPackageName();
            }
        }
        assert (false) : "Unknown scope: " + (Object)((Object)this.myRunnerParameters.getScope());
        return null;
    }

    @NotNull
    public Module[] getModules() {
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                FlexUnitRunConfiguration.$$$reportNull$$$0(2);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            FlexUnitRunConfiguration.$$$reportNull$$$0(3);
        }
        return Module.EMPTY_ARRAY;
    }

    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        FlexBuildConfiguration bc;
        if (executor == null) {
            FlexUnitRunConfiguration.$$$reportNull$$$0(4);
        }
        if (env == null) {
            FlexUnitRunConfiguration.$$$reportNull$$$0(5);
        }
        try {
            bc = (FlexBuildConfiguration)this.myRunnerParameters.checkAndGetModuleAndBC((Project)this.getProject()).second;
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        BuildConfigurationNature nature = bc.getNature();
        if (nature.isDesktopPlatform() || nature.isMobilePlatform()) {
            return new FlashRunConfiguration.AirRunState(this.getProject(), env, this.myRunnerParameters){

                @NotNull
                public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                    if (executor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (runner == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    OSProcessHandler processHandler = this.startProcess();
                    ExecutionConsole console = FlexBaseRunner.createFlexUnitRunnerConsole(FlexUnitRunConfiguration.this.getProject(), env, (ProcessHandler)processHandler);
                    DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(console, (ProcessHandler)processHandler);
                    if (defaultExecutionResult == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return defaultExecutionResult;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "runner";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "execute";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "execute";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationError {
        this.myRunnerParameters.check(this.getProject());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        FlexUnitRunnerParameters params = this.getRunnerParameters();
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(params.getModuleName());
        if (!(element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement || module != null && module.equals(ModuleUtilCore.findModuleForPsiElement((PsiElement)element)))) {
            return null;
        }
        switch (params.getScope()) {
            case Method: {
                PsiElement parent;
                if (element instanceof JSFunction && (parent = element.getParent()) instanceof JSClass && Comparing.strEqual((String)((JSClass)parent).getQualifiedName(), (String)params.getClassName()) && Comparing.strEqual((String)((JSFunction)element).getName(), (String)params.getMethodName())) {
                    return new FlexRunConfigRefactoringListener.JSFunctionRefactoringListener(this);
                }
            }
            case Class: {
                if (element instanceof PsiDirectory && FlashRunConfiguration.containsClass(module, (PsiDirectory)element, params.getClassName())) {
                    return new FlexRunConfigRefactoringListener.PsiDirectoryRefactoringListener((RunConfigurationBase)this);
                }
                JSClass jsClass = FlexRefactoringListenerProvider.getJSClass(element);
                if (jsClass != null && Comparing.strEqual((String)jsClass.getQualifiedName(), (String)params.getClassName())) {
                    return new FlexRunConfigRefactoringListener.JSClassRefactoringListener((RunConfigurationBase)this);
                }
            }
            case Package: {
                String currentPackage;
                String string = currentPackage = params.getScope() == FlexUnitRunnerParameters.Scope.Package ? params.getPackageName() : StringUtil.getPackageName((String)params.getClassName());
                if (!(element instanceof PsiDirectoryContainer) && !(element instanceof JSPackage) && !(element instanceof JSPackageStatement) || !Comparing.strEqual((String)FlexRefactoringListenerProvider.getPackageName(element), (String)currentPackage)) break;
                return new FlexRunConfigRefactoringListener.PackageRefactoringListener((RunConfigurationBase)this);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

