/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flashbuilder.AskPathDialog;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderImporter;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectFinder;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import java.io.File;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderOpenProcessor
extends ProjectOpenProcessorBase<FlashBuilderImporter> {
    public FlashBuilderOpenProcessor(@NotNull FlashBuilderImporter builder) {
        if (builder == null) {
            FlashBuilderOpenProcessor.$$$reportNull$$$0(0);
        }
        super((ProjectImportBuilder)builder);
    }

    public String[] getSupportedExtensions() {
        return new String[]{".project", "*.fxp", "*.fxpl"};
    }

    @Nullable
    public Icon getIcon(VirtualFile file) {
        if ("zip".equalsIgnoreCase(file.getExtension())) {
            return null;
        }
        return super.getIcon(file);
    }

    public boolean canOpenProject(VirtualFile file) {
        return file.isDirectory() ? FlashBuilderProjectFinder.isFlashBuilderProject(file.findChild(".project")) : FlashBuilderProjectFinder.isFlashBuilderProject(file) || FlashBuilderProjectFinder.hasArchiveExtension(file.getPath());
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        assert (!file.isDirectory()) : file.getPath();
        String title = FlexBundle.message("open.project.0", file.getName());
        if (FlashBuilderProjectFinder.hasArchiveExtension(file.getPath())) {
            try {
                FlashBuilderProjectFinder.checkArchiveContainsFBProject(file.getPath());
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)wizardContext.getProject(), (String)e.getMessage(), (String)title);
                return false;
            }
            String label = FlashBuilderProjectFinder.isMultiProjectArchive(file.getPath()) ? FlexBundle.message("folder.to.unzip.several.FB.projects", new Object[0]) : FlexBundle.message("folder.to.unzip.one.FB.project", new Object[0]);
            String path = FileUtil.toSystemDependentName((String)(wizardContext.getProjectFileDirectory() + "/" + file.getNameWithoutExtension()));
            AskPathDialog dialog = new AskPathDialog(title, label, path);
            if (!dialog.showAndGet()) {
                return false;
            }
            File projectDir = new File(dialog.getPath());
            if (!projectDir.exists() && !projectDir.mkdirs()) {
                Messages.showErrorDialog((String)("Unable to create folder: " + dialog.getPath()), (String)title);
                return false;
            }
            wizardContext.setProjectFileDirectory(dialog.getPath());
        }
        ((FlashBuilderImporter)this.getBuilder()).setInitiallySelectedPath(file.getPath());
        ((FlashBuilderImporter)this.getBuilder()).setList(Collections.singletonList(file.getPath()));
        wizardContext.setProjectName(((FlashBuilderImporter)this.getBuilder()).getSuggestedProjectName());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderOpenProcessor", "<init>"));
    }
}

