/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.DumpSourceLocationCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexSuspendContext;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.PsiBackedSmartStepIntoVariant;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class FlexSmartStepIntoHandler
extends XSmartStepIntoHandler<PsiBackedSmartStepIntoVariant> {
    private final FlexDebugProcess myDebugProcess;

    FlexSmartStepIntoHandler(FlexDebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public List<PsiBackedSmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            FlexSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        TreeMap<PsiElement, PsiBackedSmartStepIntoVariant> element2candidateMap = new TreeMap<PsiElement, PsiBackedSmartStepIntoVariant>((o1, o2) -> o1.getTextOffset() - o2.getTextOffset());
        this.compute(document, element2candidateMap, (THashSet<PsiElement>)new THashSet(), position.getLine(), position.getOffset());
        ArrayList<PsiBackedSmartStepIntoVariant> variants = new ArrayList<PsiBackedSmartStepIntoVariant>();
        for (PsiElement key : element2candidateMap.keySet()) {
            PsiBackedSmartStepIntoVariant variant = (PsiBackedSmartStepIntoVariant)element2candidateMap.get(key);
            if (variants.contains(variant)) continue;
            variants.add(variant);
        }
        ArrayList<PsiBackedSmartStepIntoVariant> arrayList = variants;
        if (arrayList == null) {
            FlexSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void compute(Document document, Map<PsiElement, PsiBackedSmartStepIntoVariant> element2candidateMap, THashSet<PsiElement> visited, int line, int offset) {
        XDebuggerUtil.getInstance().iterateLine(this.myDebugProcess.getSession().getProject(), document, line, psiElement -> {
            this.addVariants((PsiElement)psiElement, element2candidateMap, visited, offset);
            return true;
        });
    }

    private void addVariants(PsiElement psiElement, final Map<PsiElement, PsiBackedSmartStepIntoVariant> element2candidateMap, final THashSet<PsiElement> visited, final int offset) {
        PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLanguageInjectionHost.class);
        if (injectionHost != null) {
            visited.add((Object)injectionHost);
            InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
                    int fileOffsetInHost = InjectedLanguageManager.getInstance((Project)file.getProject()).injectedToHost((PsiElement)file, file.getTextRange().getStartOffset());
                    int offsetInInjected = offset - fileOffsetInHost;
                    FlexSmartStepIntoHandler.this.compute(document, element2candidateMap, (THashSet<PsiElement>)visited, document.getLineNumber(offsetInInjected), offset);
                }
            });
            return;
        }
        JSReferenceExpression expr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSReferenceExpression.class);
        if (expr != null && !visited.contains((Object)expr)) {
            visited.add((Object)expr);
            PsiElement resolve = expr.resolve();
            if (resolve instanceof JSFunction) {
                JSFunction fun = (JSFunction)resolve;
                JSReferenceExpression responsibleElement = expr;
                PsiElement parent = responsibleElement.getParent();
                if (parent instanceof JSDefinitionExpression) {
                    responsibleElement = parent.getParent();
                } else if (parent instanceof JSCallExpression) {
                    responsibleElement = parent;
                }
                element2candidateMap.put((PsiElement)responsibleElement, new JSFunctionSmartStepIntoVariant(fun));
            }
        }
    }

    public void startStepInto(final @NotNull PsiBackedSmartStepIntoVariant stepIntoVariant) {
        if (stepIntoVariant == null) {
            FlexSmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        this.myDebugProcess.sendCommand(new DebuggerCommand("bt", CommandOutputProcessingType.SPECIAL_PROCESSING){

            @Override
            CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                FlexSmartStepIntoHandler.this.startStepInto(stepIntoVariant, FlexSmartStepIntoHandler.getStackTraceFromBtCommandOutput(s));
                return super.onTextAvailable(s);
            }
        });
    }

    private void startStepInto(final PsiBackedSmartStepIntoVariant stepIntoVariant, final String[] originalStackTrace) {
        this.myDebugProcess.sendCommand(new DebuggerCommand("step", CommandOutputProcessingType.SPECIAL_PROCESSING){

            @Override
            CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                FlexSmartStepIntoHandler.this.myDebugProcess.sendCommand(new DebuggerCommand("bt", CommandOutputProcessingType.SPECIAL_PROCESSING){

                    @Override
                    CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                        FlexSmartStepIntoHandler.this.handleStepInto(stepIntoVariant, originalStackTrace, s);
                        return super.onTextAvailable(s);
                    }
                });
                return super.onTextAvailable(s);
            }
        });
    }

    private void handleStepInto(PsiBackedSmartStepIntoVariant stepIntoVariant, String[] originalStackTrace, String btCommandOutput) {
        if (FlexSmartStepIntoHandler.isCorrectFrameReached(stepIntoVariant, btCommandOutput)) {
            this.myDebugProcess.sendCommand(new DumpSourceLocationCommand(this.myDebugProcess));
        } else if (!FlexSmartStepIntoHandler.arrayEndsWith(FlexSmartStepIntoHandler.getStackTraceFromBtCommandOutput(btCommandOutput), originalStackTrace)) {
            this.myDebugProcess.sendCommand(new FlexDebugProcess.ContinueCommand());
        } else {
            this.myDebugProcess.sendCommand(new DebuggerCommand("finish", CommandOutputProcessingType.SPECIAL_PROCESSING));
            this.startStepInto(stepIntoVariant, originalStackTrace);
        }
    }

    private static String[] getStackTraceFromBtCommandOutput(String btCommandOutput) {
        String[] frames = FlexSuspendContext.splitStackFrames(btCommandOutput);
        for (int i = 0; i < frames.length; ++i) {
            String frame = frames[i];
            frames[i] = frame.substring(frame.indexOf(" ") + 1).trim();
        }
        return frames;
    }

    private static boolean isCorrectFrameReached(PsiBackedSmartStepIntoVariant stepIntoVariant, String btCommandOutput) {
        String functionName = stepIntoVariant.getElement().getName();
        String scope = FlexSuspendContext.extractScope(FlexSuspendContext.splitStackFrames(btCommandOutput)[0]);
        return scope.equals(functionName) || scope.startsWith(functionName + ":") || scope.contains(" " + functionName + ":");
    }

    private static boolean arrayEndsWith(String[] array, String[] subArray) {
        return ArrayUtil.startsWith((Object[])ArrayUtil.reverseArray((Object[])array), (Object[])ArrayUtil.reverseArray((Object[])subArray));
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            FlexSmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        return FlexBundle.message("popup.title.step.into.function", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/debug/FlexSmartStepIntoHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepIntoVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/debug/FlexSmartStepIntoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSFunctionSmartStepIntoVariant
    extends PsiBackedSmartStepIntoVariant<JSFunction> {
        public JSFunctionSmartStepIntoVariant(@NotNull JSFunction element) {
            if (element == null) {
                JSFunctionSmartStepIntoVariant.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            JSFunctionSmartStepIntoVariant that = (JSFunctionSmartStepIntoVariant)((Object)o);
            return ((JSFunction)this.getElement()).equals(that.getElement());
        }

        public int hashCode() {
            return ((JSFunction)this.getElement()).hashCode();
        }

        public String getText() {
            return JSFormatUtil.formatMethod((JSFunction)((JSFunction)this.getElement()), (int)257, (int)2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/debug/FlexSmartStepIntoHandler$JSFunctionSmartStepIntoVariant", "<init>"));
        }
    }
}

