/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.CommonBundle;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlexCompilationTask;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerDependenciesCache;
import com.intellij.lang.javascript.flex.build.FlexCompilerException;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.FlexCompilerProjectConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class FlexCompilationManager {
    private final CompileContext myCompileContext;
    private final int myMaxParallelCompilations;
    private final int myTasksAmount;
    private final Collection<FlexCompilationTask> myNotStartedTasks;
    private final Collection<FlexCompilationTask> myInProgressTasks;
    private final Collection<FlexCompilationTask> myFinishedTasks;
    private boolean myCompilationFinished;
    private final FlexCompilerDependenciesCache myCompilerDependenciesCache;
    static final Pattern OUTPUT_FILE_CREATED_PATTERN = Pattern.compile("(\\[.*\\] )?(.+) \\(([0-9]+) bytes\\)");
    private static final String BYTES_WRITTEN_TO = " bytes written to ";

    public FlexCompilationManager(CompileContext context, Collection<FlexCompilationTask> compilationTasks) {
        this.myCompileContext = context;
        this.myMaxParallelCompilations = FlexCompilerProjectConfiguration.getInstance((Project)context.getProject()).MAX_PARALLEL_COMPILATIONS;
        this.myTasksAmount = compilationTasks.size();
        this.myNotStartedTasks = new LinkedList<FlexCompilationTask>(compilationTasks);
        this.myInProgressTasks = new LinkedList<FlexCompilationTask>();
        this.myFinishedTasks = new LinkedList<FlexCompilationTask>();
        this.myCompilationFinished = false;
        this.myCompilerDependenciesCache = FlexCompilerHandler.getInstance(context.getProject()).getCompilerDependenciesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile() {
        try {
            while (!this.myNotStartedTasks.isEmpty() || !this.myInProgressTasks.isEmpty()) {
                if (this.myCompileContext.getProgressIndicator().isCanceled()) {
                    for (FlexCompilationTask task : this.myInProgressTasks) {
                        task.cancel();
                    }
                    return;
                }
                this.checkFinishedTasks();
                this.startNewTaskIfPossible();
                this.updateProgressIndicator();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    assert (false);
                    continue;
                    return;
                }
            }
        }
        finally {
            FlexCompilationManager flexCompilationManager = this;
            synchronized (flexCompilationManager) {
                this.myCompilationFinished = true;
            }
        }
    }

    public synchronized void addMessage(FlexCompilationTask task, CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum) {
        if (!this.myCompilationFinished) {
            if (message.contains("Could not create the Java virtual machine")) {
                category = CompilerMessageCategory.ERROR;
            }
            if (category == CompilerMessageCategory.INFORMATION) {
                int bytesWrittenIndex = message.indexOf(BYTES_WRITTEN_TO);
                if (bytesWrittenIndex > 0) {
                    int inIndex = message.lastIndexOf(" in ");
                    if (inIndex > bytesWrittenIndex) {
                        String outputFilePath = message.substring(bytesWrittenIndex + BYTES_WRITTEN_TO.length(), inIndex);
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            FlexCompilationManager.refreshAndFindFileInWriteAction(outputFilePath, new String[0]);
                        }
                    }
                } else {
                    Matcher matcher = OUTPUT_FILE_CREATED_PATTERN.matcher(message);
                    if (matcher.matches()) {
                        String outputFilePath = matcher.group(2);
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            FlexCompilationManager.refreshAndFindFileInWriteAction(outputFilePath, new String[0]);
                        }
                    }
                }
            }
            String prefix = this.getMessagePrefix(task);
            this.myCompileContext.addMessage(category, prefix + message, url, lineNum, columnNum);
            if (message.contains("java.lang.OutOfMemoryError") || message.contains("Java heap space")) {
                this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, prefix + FlexCommonBundle.message((String)"increase.flex.compiler.heap", (Object[])new Object[]{CommonBundle.settingsActionPath()}), null, -1, -1);
            }
        }
    }

    public boolean isRebuild() {
        return !this.myCompileContext.isMake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinishedTasks() {
        Iterator<FlexCompilationTask> iterator = this.myInProgressTasks.iterator();
        while (iterator.hasNext()) {
            FlexCompilationTask task = iterator.next();
            if (!task.isFinished()) continue;
            iterator.remove();
            this.myFinishedTasks.add(task);
            if (task.isCompilationFailed()) {
                Collection<FlexCompilationTask> cancelledTasks = this.cancelNotStartedDependentTasks(task);
                if (cancelledTasks.isEmpty()) {
                    this.addMessage(task, CompilerMessageCategory.INFORMATION, FlexCommonBundle.message((String)"compilation.failed", (Object[])new Object[0]), null, -1, -1);
                } else {
                    this.addMessage(task, CompilerMessageCategory.INFORMATION, FlexCommonBundle.message((String)"compilation.failed.dependent.will.be.skipped", (Object[])new Object[0]), null, -1, -1);
                    for (FlexCompilationTask flexCompilationTask : cancelledTasks) {
                        this.addMessage(flexCompilationTask, CompilerMessageCategory.INFORMATION, FlexBundle.message("compilation.skipped", new Object[0]), null, -1, -1);
                    }
                }
            } else {
                this.addMessage(task, CompilerMessageCategory.INFORMATION, FlexCommonBundle.message((String)"compilation.successful", (Object[])new Object[0]), null, -1, -1);
                String prefix = this.getMessagePrefix(task);
                ArrayList<String> taskMessages = new ArrayList<String>();
                for (CompilerMessage message : this.myCompileContext.getMessages(CompilerMessageCategory.INFORMATION)) {
                    if (!message.getMessage().startsWith(prefix)) continue;
                    taskMessages.add(message.getMessage().substring(prefix.length()));
                }
                try {
                    FlexCompilationUtils.performPostCompileActions(task.getModule(), task.getBC(), taskMessages);
                }
                catch (FlexCompilerException flexCompilerException) {
                    this.addMessage(task, CompilerMessageCategory.ERROR, flexCompilerException.getMessage(), flexCompilerException.getUrl(), flexCompilerException.getLine(), flexCompilerException.getColumn());
                }
            }
            if (task.isCompilationFailed()) {
                this.myCompilerDependenciesCache.markBCDirty(task.getModule(), task.getBC());
                continue;
            }
            FlexCompilationManager flexCompilationManager = this;
            synchronized (flexCompilationManager) {
                this.myCompilerDependenciesCache.cacheBC(task.getModule(), task.getBC(), task.getConfigFiles());
            }
        }
    }

    private String getMessagePrefix(FlexCompilationTask task) {
        return "[" + task.getPresentableName() + "] ";
    }

    private Collection<FlexCompilationTask> cancelNotStartedDependentTasks(FlexCompilationTask failedTask) {
        LinkedList<FlexCompilationTask> tasksToCancel = new LinkedList<FlexCompilationTask>();
        this.appendAndCancelNotStartedDependentTasks(tasksToCancel, failedTask);
        if (BCUtils.canHaveRLMsAndRuntimeStylesheets(failedTask.getBC())) {
            this.appendAndCancelNotStartedRLMTasks(tasksToCancel, failedTask.getModule(), failedTask.getBC());
        }
        return tasksToCancel;
    }

    private void appendAndCancelNotStartedDependentTasks(Collection<FlexCompilationTask> cancelledTasks, FlexCompilationTask task) {
        ArrayList<FlexCompilationTask> tasksToCancel = new ArrayList<FlexCompilationTask>();
        for (FlexCompilationTask notStartedTask : this.myNotStartedTasks) {
            if (!notStartedTask.getDependencies().contains(task.getBC())) continue;
            tasksToCancel.add(notStartedTask);
        }
        for (FlexCompilationTask taskToCancel : tasksToCancel) {
            taskToCancel.cancel();
            if (!this.myNotStartedTasks.remove(taskToCancel)) continue;
            this.myFinishedTasks.add(taskToCancel);
            cancelledTasks.add(taskToCancel);
            this.appendAndCancelNotStartedDependentTasks(cancelledTasks, taskToCancel);
        }
    }

    private void appendAndCancelNotStartedRLMTasks(Collection<FlexCompilationTask> tasks, Module module, FlexBuildConfiguration bc) {
        Iterator<FlexCompilationTask> iterator = this.myNotStartedTasks.iterator();
        while (iterator.hasNext()) {
            FlexCompilationTask task = iterator.next();
            if (module != task.getModule() || !bc.getName().equals(task.getBC().getName()) || !BCUtils.isRLMTemporaryBC(task.getBC())) continue;
            iterator.remove();
            this.myFinishedTasks.add(task);
            tasks.add(task);
        }
    }

    private void startNewTaskIfPossible() {
        FlexCompilationTask taskToStart = null;
        if (!this.myNotStartedTasks.isEmpty() && this.myInProgressTasks.size() < this.myMaxParallelCompilations) {
            boolean allTasksHaveDependenciesOnlyInNotStarted = true;
            for (FlexCompilationTask task : this.myNotStartedTasks) {
                if (BCUtils.isRLMTemporaryBC(task.getBC()) && !this.isMainAppCompiledForRLM(task.getModule(), task.getBC())) {
                    allTasksHaveDependenciesOnlyInNotStarted = false;
                    continue;
                }
                if (FlexCompilationManager.hasDependenciesIn(task, this.myInProgressTasks)) {
                    allTasksHaveDependenciesOnlyInNotStarted = false;
                    continue;
                }
                if (FlexCompilationManager.hasDependenciesIn(task, this.myNotStartedTasks)) continue;
                taskToStart = task;
                break;
            }
            if (taskToStart == null && allTasksHaveDependenciesOnlyInNotStarted) {
                taskToStart = this.myNotStartedTasks.iterator().next();
            }
            if (taskToStart != null) {
                this.myNotStartedTasks.remove(taskToStart);
                if (this.myCompilerDependenciesCache.isNothingChangedSincePreviousCompilation(taskToStart.getModule(), taskToStart.getBC())) {
                    this.addMessage(taskToStart, CompilerMessageCategory.INFORMATION, FlexBundle.message("compilation.skipped.because.nothing.changed", new Object[0]), null, -1, -1);
                    taskToStart.cancel();
                    this.myFinishedTasks.add(taskToStart);
                    try {
                        FlexCompilationUtils.performPostCompileActions(taskToStart.getModule(), taskToStart.getBC(), Collections.emptyList());
                    }
                    catch (FlexCompilerException e) {
                        this.addMessage(taskToStart, CompilerMessageCategory.ERROR, e.getMessage(), e.getUrl(), e.getLine(), e.getColumn());
                    }
                } else {
                    taskToStart.start(this);
                    this.myInProgressTasks.add(taskToStart);
                }
                this.startNewTaskIfPossible();
            }
        }
    }

    private boolean isMainAppCompiledForRLM(Module module, FlexBuildConfiguration rlmBC) {
        for (FlexCompilationTask task : this.myFinishedTasks) {
            FlexBuildConfiguration bc = task.getBC();
            if (task.getModule() != module || !bc.getName().equals(rlmBC.getName()) || BCUtils.isRLMTemporaryBC(bc) || BCUtils.isRuntimeStyleSheetBC(bc) || !BCUtils.canHaveRLMsAndRuntimeStylesheets(bc) || bc.getRLMs().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDependenciesIn(FlexCompilationTask task, Collection<FlexCompilationTask> tasksToSearchDependencies) {
        for (FlexCompilationTask otherTask : tasksToSearchDependencies) {
            if (!task.getDependencies().contains(otherTask.getBC())) continue;
            return true;
        }
        return false;
    }

    private void updateProgressIndicator() {
        ProgressIndicator progressIndicator = this.myCompileContext.getProgressIndicator();
        progressIndicator.setFraction(1.0 * (double)this.myFinishedTasks.size() / (double)this.myTasksAmount);
        StringBuilder builder = new StringBuilder();
        if (!this.myInProgressTasks.isEmpty()) {
            for (FlexCompilationTask inProgressTask : this.myInProgressTasks) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(inProgressTask.getPresentableName());
            }
            progressIndicator.setText(FlexCommonBundle.message((String)"compiling", (Object[])new Object[]{builder.toString()}));
        }
    }

    static VirtualFile refreshAndFindFileInWriteAction(final String outputFilePath, final String ... possibleBaseDirs) {
        final LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Ref outputFileRef = new Ref();
        Application app = ApplicationManager.getApplication();
        app.invokeAndWait(() -> outputFileRef.set(app.runWriteAction((Computable)new NullableComputable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile outputFile = localFileSystem.refreshAndFindFileByPath(outputFilePath);
                if (outputFile == null) {
                    String baseDir;
                    String[] stringArray = possibleBaseDirs;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (outputFile = localFileSystem.refreshAndFindFileByPath((baseDir = stringArray[i]) + "/" + outputFilePath)) == null; ++i) {
                    }
                }
                if (outputFile == null) {
                    return null;
                }
                outputFile.refresh(false, false);
                return outputFile;
            }
        })));
        return (VirtualFile)outputFileRef.get();
    }
}

