/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateFlexSkinDialog
extends DialogWrapper {
    private static final String SKINNABLE_COMPONENT_CLASS = "spark.components.supportClasses.SkinnableComponent";
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "CreateFlexSkinDialog.DESTINATION_PACKAGE_RECENT_KEY";
    private static final String HOST_COMPONENT_RECENT_KEY = "CreateFlexSkinDialog.HOST_COMPONENT_RECENT_KEY";
    private JPanel myMainPanel;
    private JSReferenceEditor myPackageCombo;
    private JSReferenceEditor myHostComponentCombo;
    private final Module myModule;
    private final String myPackageNameInitial;
    private final PsiFile myContextFile;
    private final String myHostComponentInitial;
    private PsiDirectory myTargetDirectory;

    protected CreateFlexSkinDialog(Module module, String skinName, String packageName, String hostComponent, PsiFile contextFile) {
        super(module.getProject());
        this.myModule = module;
        this.myPackageNameInitial = packageName;
        this.myContextFile = contextFile;
        this.myHostComponentInitial = hostComponent;
        Object[] objectArray = new Object[]{skinName};
        this.$$$setupUI$$$();
        this.setTitle(FlexBundle.message("create.skin", objectArray));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPackageCombo.getChildComponent();
    }

    public String getPackageName() {
        return this.myPackageCombo.getText().trim();
    }

    public String getHostComponent() {
        return this.myHostComponentCombo.getText().trim();
    }

    protected void doOKAction() {
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
        String packageName = this.getPackageName();
        for (String s : StringUtil.split((String)packageName, (String)".")) {
            if (namesValidator.isIdentifier(s, null)) continue;
            this.setErrorText(JSBundle.message((String)"invalid.package", (Object[])new Object[]{packageName}), (JComponent)this.myPackageCombo);
            return;
        }
        this.myHostComponentCombo.updateRecents();
        this.myPackageCombo.updateRecents();
        this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)this.myModule.getProject(), (Module)this.myModule, (GlobalSearchScope)this.getPackageScope(), (String)packageName, null, (PsiDirectory)this.myContextFile.getParent(), (ThreeState)ThreeState.UNSURE);
        if (this.myTargetDirectory != null) {
            super.doOKAction();
        }
    }

    private GlobalSearchScope getPackageScope() {
        return PlatformPackageUtil.adjustScope((PsiDirectory)this.myContextFile.getParent(), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule), (boolean)false, (boolean)true);
    }

    private void createUIComponents() {
        this.myPackageCombo = JSReferenceEditor.forPackageName((String)this.myPackageNameInitial, (Project)this.myModule.getProject(), (String)DESTINATION_PACKAGE_RECENT_KEY, (GlobalSearchScope)this.getPackageScope(), (String)RefactoringBundle.message((String)"choose.destination.package"));
        this.myHostComponentCombo = CreateFlexSkinDialog.createHostComponentCombo(this.myHostComponentInitial, this.myModule);
    }

    public static GlobalSearchScope getHostComponentScope(Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
    }

    public static JSReferenceEditor createHostComponentCombo(String text, Module module) {
        GlobalSearchScope scope = CreateFlexSkinDialog.getHostComponentScope(module);
        PublicInheritorFilter filter = new PublicInheritorFilter(module.getProject(), SKINNABLE_COMPONENT_CLASS, scope, true);
        return JSReferenceEditor.forClassName((String)text, (Project)module.getProject(), (String)HOST_COMPONENT_RECENT_KEY, (GlobalSearchScope)scope, null, (Condition)filter, (String)FlexBundle.message("choose.host.component", new Object[0]));
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Target package:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Host component:");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myPackageCombo;
        jPanel.add((Component)jSReferenceEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(250, -1), null, null));
        JSReferenceEditor jSReferenceEditor2 = this.myHostComponentCombo;
        jPanel.add((Component)jSReferenceEditor2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, new Dimension(250, -1), null, null));
        jLabel.setLabelFor((Component)jSReferenceEditor);
        jLabel2.setLabelFor((Component)jSReferenceEditor2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

