/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.addAsLib;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.actions.addAsLib.AddAsSwcLibDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddAsSwcLibAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = AddAsSwcLibAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        List<VirtualFile> roots = AddAsSwcLibAction.getRoots(e);
        if (!roots.isEmpty()) {
            VirtualFile file = roots.get(0);
            if (!file.isInLocalFileSystem()) {
                file = JarFileSystem.getInstance().getLocalByEntry(file);
            }
            Module module = file == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            new AddAsSwcLibDialog(project, module, roots).show();
        }
    }

    public void update(AnActionEvent e) {
        Project project = AddAsSwcLibAction.getEventProject((AnActionEvent)e);
        boolean enabled = project != null && AddAsSwcLibAction.containsFlashModule(project) && !AddAsSwcLibAction.getRoots(e).isEmpty();
        e.getPresentation().setText(FlexBundle.message("add.as.library.title", new Object[0]) + "...");
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    private static List<VirtualFile> getRoots(AnActionEvent e) {
        Project project = AddAsSwcLibAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || files == null || files.length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                AddAsSwcLibAction.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            VirtualFile root;
            if (file.isDirectory()) {
                for (VirtualFile child : file.getChildren()) {
                    VirtualFile jarRoot;
                    if (!FileUtilRt.extensionEquals((String)child.getName(), (String)"swc") || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child)) == null) continue;
                    roots.add(file);
                }
                continue;
            }
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"swc") || (root = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
            roots.add(root);
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            AddAsSwcLibAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean containsFlashModule(Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/actions/addAsLib/AddAsSwcLibAction", "getRoots"));
    }
}

