/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions;

import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class FlexBCTree
extends CheckboxTree {
    private final Project myProject;
    private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);

    public FlexBCTree(Project project) {
        this(project, (Condition<FlexBuildConfiguration>)Conditions.alwaysTrue());
    }

    public FlexBCTree(Project project, Condition<FlexBuildConfiguration> bcFilter) {
        super(FlexBCTree.createRenderer(), new CheckedTreeNode((Object)project), new CheckboxTreeBase.CheckPolicy(true, true, true, true));
        this.myProject = project;
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        CheckedTreeNode rootNode = (CheckedTreeNode)this.getModel().getRoot();
        this.addNodes(rootNode, bcFilter);
        ((DefaultTreeModel)this.getModel()).reload((TreeNode)rootNode);
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void addToggleCheckBoxListener(ChangeListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        ((ChangeListener)this.myDispatcher.getMulticaster()).stateChanged(new ChangeEvent(node));
    }

    public Collection<Pair<Module, FlexBuildConfiguration>> getSelectedBCs() {
        return this.getBCs(true);
    }

    public Collection<Pair<Module, FlexBuildConfiguration>> getDeselectedBCs() {
        return this.getBCs(false);
    }

    private Collection<Pair<Module, FlexBuildConfiguration>> getBCs(boolean checked) {
        CollectConsumer consumer = new CollectConsumer();
        FlexBCTree.iterateRecursively((CheckedTreeNode)this.getModel().getRoot(), checked, (Consumer<Pair<Module, FlexBuildConfiguration>>)consumer);
        return consumer.getResult();
    }

    public void setCheckedStatusForAll(boolean checked) {
        CheckedTreeNode node = (CheckedTreeNode)this.getModel().getRoot();
        node.setChecked(checked);
        FlexBCTree.setChildrenCheckedRecursively(node, checked);
    }

    private static void setChildrenCheckedRecursively(CheckedTreeNode node, boolean checked) {
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            CheckedTreeNode childNode = (CheckedTreeNode)children.nextElement();
            childNode.setChecked(checked);
            FlexBCTree.setChildrenCheckedRecursively(childNode, checked);
        }
    }

    public void setChecked(String moduleName, String bcName, boolean checked) {
        CheckedTreeNode node = this.getBCNode(moduleName, bcName);
        if (node != null) {
            node.setChecked(checked);
        }
    }

    private CheckedTreeNode getBCNode(String moduleName, String bcName) {
        Enumeration moduleNodes = ((CheckedTreeNode)this.getModel().getRoot()).children();
        while (moduleNodes.hasMoreElements()) {
            CheckedTreeNode moduleNode = (CheckedTreeNode)moduleNodes.nextElement();
            Object userObject = moduleNode.getUserObject();
            if (!(userObject instanceof Module) || !((Module)userObject).getName().equals(moduleName)) continue;
            Enumeration bcNodes = moduleNode.children();
            while (bcNodes.hasMoreElements()) {
                CheckedTreeNode bcNode = (CheckedTreeNode)bcNodes.nextElement();
                Object bcUserObject = bcNode.getUserObject();
                if (!(bcUserObject instanceof FlexBuildConfiguration) || !((FlexBuildConfiguration)bcUserObject).getName().equals(bcName)) continue;
                return bcNode;
            }
            return null;
        }
        return null;
    }

    public void selectRow(Module module, FlexBuildConfiguration bc) {
        this.clearSelection();
        CheckedTreeNode node = this.getBCNode(module.getName(), bc.getName());
        if (node != null) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)((Object)this));
        }
    }

    private static void iterateRecursively(CheckedTreeNode node, boolean iterateChecked, Consumer<Pair<Module, FlexBuildConfiguration>> consumer) {
        block2: {
            block1: {
                if (!node.isLeaf()) break block1;
                if (node.isChecked() != iterateChecked || !(node.getParent() instanceof CheckedTreeNode)) break block2;
                Object userObject = node.getUserObject();
                Object parentUserObject = ((CheckedTreeNode)node.getParent()).getUserObject();
                if (!(userObject instanceof FlexBuildConfiguration) || !(parentUserObject instanceof Module)) break block2;
                consumer.consume((Object)Pair.create((Object)((Module)parentUserObject), (Object)((FlexBuildConfiguration)userObject)));
                break block2;
            }
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                FlexBCTree.iterateRecursively((CheckedTreeNode)children.nextElement(), iterateChecked, consumer);
            }
        }
    }

    private static CheckboxTree.CheckboxTreeCellRenderer createRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof Project) {
                    this.getTextRenderer().append(((Project)userObject).getName());
                } else if (userObject instanceof Module) {
                    this.getTextRenderer().setIcon(ModuleType.get((Module)((Module)userObject)).getIcon());
                    this.getTextRenderer().append(((Module)userObject).getName());
                } else if (userObject instanceof FlexBuildConfiguration) {
                    BCUtils.renderBuildConfiguration((FlexBuildConfiguration)userObject, null, false).appendToComponent((ColoredTextContainer)this.getTextRenderer());
                    this.getTextRenderer().setIcon(((FlexBuildConfiguration)userObject).getIcon());
                }
            }
        };
    }

    private void addNodes(CheckedTreeNode rootNode, Condition<FlexBuildConfiguration> bcFilter) {
        FlexModuleType flexModuleType = FlexModuleType.getInstance();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (ModuleType.get((Module)module) != flexModuleType) continue;
            CheckedTreeNode moduleNode = new CheckedTreeNode((Object)module);
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                if (!bcFilter.value((Object)bc)) continue;
                moduleNode.add((MutableTreeNode)new CheckedTreeNode((Object)bc));
            }
            if (moduleNode.getChildCount() <= 0) continue;
            rootNode.add((MutableTreeNode)moduleNode);
        }
    }

    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, path -> {
            CheckedTreeNode node = (CheckedTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject instanceof Project) {
                return ((Project)userObject).getName();
            }
            if (userObject instanceof Module) {
                return ((Module)userObject).getName();
            }
            if (userObject instanceof FlexBuildConfiguration) {
                return ((FlexBuildConfiguration)userObject).getName();
            }
            return null;
        });
    }
}

