/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.flex.ReferenceSupport;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFlexFileReference
extends FileReference {
    private final ReferenceSupport.RelativeToWhat myRelativeToWhat;

    public JSFlexFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text, ReferenceSupport.RelativeToWhat relativeToWhat) {
        if (fileReferenceSet == null) {
            JSFlexFileReference.$$$reportNull$$$0(0);
        }
        super(fileReferenceSet, range, index, text);
        this.myRelativeToWhat = relativeToWhat;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        VirtualFile currentVFile;
        if (element == null) {
            JSFlexFileReference.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile destVFile = fileSystemItem.getVirtualFile();
        if (destVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        PsiFile currentPsiFile = this.getElement().getContainingFile();
        PsiElement contextPsiFile = currentPsiFile.getContext();
        if (contextPsiFile != null) {
            currentPsiFile = contextPsiFile.getContainingFile();
        }
        if ((currentVFile = currentPsiFile.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + currentPsiFile);
        }
        Project project = element.getProject();
        String newName = null;
        block0 : switch (this.myRelativeToWhat) {
            case Absolute: {
                newName = destVFile.getPath();
                break;
            }
            case CurrentFile: {
                newName = JSFlexFileReference.getRelativePath(currentVFile, destVFile, '/');
                break;
            }
            case ProjectRoot: {
                VirtualFile projectRoot = project.getBaseDir();
                newName = projectRoot == null ? null : JSFlexFileReference.getRelativePath(projectRoot, destVFile, '/');
                break;
            }
            case SourceRoot: {
                VirtualFile[] sourceRoots;
                VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(destVFile);
                if (sourceRootForFile != null) {
                    newName = JSFlexFileReference.getRelativePath(sourceRootForFile, destVFile, '/');
                    break;
                }
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)currentVFile, (Project)project);
                if (module == null) break;
                for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                    String relativePath = JSFlexFileReference.getRelativePath(sourceRoot, destVFile, '/');
                    if (relativePath == null) continue;
                    newName = relativePath;
                    break block0;
                }
                break;
            }
        }
        if (newName != null && this.getFileReferenceSet().getPathString().startsWith("/") && !newName.startsWith("/")) {
            newName = "/" + newName;
        }
        return newName == null ? element : this.rename(newName);
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        VirtualFile commonAncestor;
        if (src == null) {
            JSFlexFileReference.$$$reportNull$$$0(2);
        }
        if (dst == null) {
            JSFlexFileReference.$$$reportNull$$$0(3);
        }
        if ((commonAncestor = VfsUtil.getCommonAncestor((VirtualFile)src, (VirtualFile)dst)) != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                if (src.isDirectory()) {
                    buffer.append("..").append(separatorChar);
                }
                while (!Comparing.equal((Object)src.getParent(), (Object)commonAncestor)) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                }
            }
            buffer.append(VfsUtilCore.getRelativePath((VirtualFile)dst, (VirtualFile)commonAncestor, (char)separatorChar));
            return buffer.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/JSFlexFileReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

