/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.lang.ant.config.execution.AntMessageCustomizer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class FlexAntMessageCustomizer
extends AntMessageCustomizer {
    private static final String ERROR_MARKER = " Error: ";
    private static final String WARNING_MARKER = " Warning: ";
    public static final String COL_MARKER = "col: ";

    @Nullable
    public AntMessage createCustomizedMessage(String text, int priority) {
        String potentialPath;
        String lowercasedPath;
        String pathAndInfoAndPosition;
        int braceIndex;
        boolean isWarning = false;
        int errorOrWarningIndex = text.indexOf(ERROR_MARKER);
        if (errorOrWarningIndex == -1) {
            errorOrWarningIndex = text.indexOf(WARNING_MARKER);
            isWarning = true;
        }
        if (errorOrWarningIndex > 0 && (braceIndex = (pathAndInfoAndPosition = text.substring(0, errorOrWarningIndex)).indexOf(40)) > 0 && ((lowercasedPath = (potentialPath = pathAndInfoAndPosition.substring(0, braceIndex)).toLowerCase()).endsWith(".as") || lowercasedPath.endsWith(".mxml") || lowercasedPath.endsWith(".fxg") || lowercasedPath.endsWith(".css"))) {
            int lineCloseBraceIndex;
            String infoAndPosition = pathAndInfoAndPosition.substring(lowercasedPath.length());
            int lineOpenBraceIndex = infoAndPosition.lastIndexOf("(");
            int n = lineCloseBraceIndex = lineOpenBraceIndex < 0 ? -1 : infoAndPosition.indexOf("):", lineOpenBraceIndex);
            if (lineOpenBraceIndex >= 0 && lineCloseBraceIndex > lineOpenBraceIndex + 1) {
                String lineString = infoAndPosition.substring(lineOpenBraceIndex + 1, lineCloseBraceIndex);
                try {
                    VirtualFile file;
                    int line = Integer.parseInt(lineString);
                    int column = 1;
                    int colIndex = infoAndPosition.indexOf(COL_MARKER, lineCloseBraceIndex);
                    if (colIndex > 0 && colIndex < infoAndPosition.length() - COL_MARKER.length() - 1) {
                        String colString = infoAndPosition.substring(colIndex + COL_MARKER.length(), infoAndPosition.length());
                        column = Integer.parseInt(colString);
                    }
                    if ((file = LocalFileSystem.getInstance().findFileByPath(potentialPath)) != null) {
                        String textWithoutPosition = potentialPath + infoAndPosition.substring(0, lineOpenBraceIndex) + ": " + text.substring(errorOrWarningIndex + ERROR_MARKER.length());
                        return new AntMessage(isWarning ? AntBuildMessageView.MessageType.MESSAGE : AntBuildMessageView.MessageType.ERROR, isWarning ? 1 : 0, textWithoutPosition, file, line, column);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

