/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.flex.library.ActionScriptLibraryProvider;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptResolveScopeProvider
extends JSResolveScopeProvider
implements JSElementResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            ActionScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        return ActionScriptResolveScopeProvider.getResolveScope(file, project, true);
    }

    @Nullable
    private static GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project, boolean checkApplicable) {
        if (file == null) {
            ActionScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if (checkApplicable && !ActionScriptResolveScopeProvider.isApplicable(file)) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(file);
        if (module != null) {
            boolean includeTests = projectFileIndex.isInTestSourceContent(file) || !projectFileIndex.isInSourceContent(file);
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
            GlobalSearchScope fileTypesScope = moduleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)moduleScope, (FileType[])new FileType[]{TypeScriptFileType.INSTANCE, JavaScriptFileType.INSTANCE})));
            return fileTypesScope.union((SearchScope)GlobalSearchScope.filesScope((Project)project, ActionScriptLibraryProvider.getActionScriptPredefinedLibraryFiles()));
        }
        return null;
    }

    @Nullable
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope scope;
        GlobalSearchScope forced;
        GlobalSearchScope tempScope;
        if (element == null) {
            ActionScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if ((tempScope = JSInheritanceUtil.getEnforcedScope()) != null) {
            return tempScope;
        }
        PsiElement explicitContext = JSResolveUtil.getContext((PsiElement)element);
        if (explicitContext != null) {
            element = explicitContext;
        }
        if (element instanceof PsiCodeFragment && (forced = ((PsiCodeFragment)element).getForcedResolveScope()) != null) {
            return forced;
        }
        if (!DialectDetector.isActionScript((PsiElement)element)) {
            return null;
        }
        Project project = element.getProject();
        VirtualFile file = ActionScriptResolveScopeProvider.getFileForScopeEvaluation((PsiElement)element);
        if (file == null) {
            return this.getProjectScopeIncludingPredefines(project);
        }
        GlobalSearchScope globalSearchScope = scope = ActionScriptResolveScopeProvider.isApplicable(file) ? ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(file) : null;
        if (scope != null) {
            if (ProjectFileIndex.SERVICE.getInstance((Project)project).isInLibraryClasses(file) && !scope.contains(file)) {
                return scope.union((SearchScope)GlobalSearchScope.fileScope((Project)project, (VirtualFile)file));
            }
            return scope;
        }
        GlobalSearchScope fileResolveScope = ActionScriptResolveScopeProvider.getResolveScope(file, project, false);
        return fileResolveScope != null ? fileResolveScope : this.getProjectScopeIncludingPredefines(project);
    }

    protected List<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            ActionScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        return JSResolveUtil.JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project).stream().filter(ActionScriptResolveScopeProvider::isApplicable).collect(Collectors.toList());
    }

    private static boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            ActionScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return file.getFileType() == ActionScriptFileType.INSTANCE || file.getFileType() == FlexApplicationComponent.MXML || file.getFileType() == FlexApplicationComponent.SWF_FILE_TYPE || JavaScriptSupportLoader.isFlexMxmFile((VirtualFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResolveScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementResolveScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPredefinedLibraryFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

