/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.moveClass;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexMoveClassProcessor
extends MoveFilesOrDirectoriesProcessor {
    private final Collection<JSQualifiedNamedElement> myElements;
    private final String myTargetPackage;

    public FlexMoveClassProcessor(Collection<JSQualifiedNamedElement> elements, PsiDirectory targetDirectory, String targetPackage, boolean searchInComments, boolean searchForTextOccurencies, @Nullable MoveCallback callback) {
        super(elements.iterator().next().getProject(), (PsiElement[])ContainerUtil.map2Array(elements, PsiElement.class, e -> e.getContainingFile()), targetDirectory, true, searchInComments, searchForTextOccurencies, callback, null);
        this.myElements = elements;
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FlexMoveClassProcessor.$$$reportNull$$$0(0);
        }
        FlexMoveClassUsageViewDescriptor flexMoveClassUsageViewDescriptor = new FlexMoveClassUsageViewDescriptor();
        if (flexMoveClassUsageViewDescriptor == null) {
            FlexMoveClassProcessor.$$$reportNull$$$0(1);
        }
        return flexMoveClassUsageViewDescriptor;
    }

    protected String getCommandName() {
        StringBuilder s = new StringBuilder();
        for (JSQualifiedNamedElement element : this.myElements) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(FlexBundle.message("moved.element.description", StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)element).humanReadableKey(), (Object[])new Object[0])), element.getQualifiedName()));
        }
        return FlexBundle.message("move.command.name", s, JSFormatUtil.formatPackage((String)this.myTargetPackage));
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Collection<UsageInfo> result = Collections.synchronizedCollection(new ArrayList());
        result.addAll(Arrays.asList(super.findUsages()));
        for (JSQualifiedNamedElement element : this.myElements) {
            if (element instanceof JSClass) {
                JSRefactoringUtil.addConstructorUsages((JSClass)((JSClass)element), result);
            }
            TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (String)element.getQualifiedName(), (boolean)this.mySearchInComments, (boolean)this.mySearchInNonJavaFiles, (String)StringUtil.getQualifiedName((String)this.myTargetPackage, (String)element.getName()), result);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            FlexMoveClassProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            FlexMoveClassProcessor.$$$reportNull$$$0(3);
        }
        return this.showConflicts(this.detectConflicts((UsageInfo[])refUsages.get()), (UsageInfo[])refUsages.get());
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FlexMoveClassProcessor.$$$reportNull$$$0(4);
        }
        if (UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    private MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        List<PsiElement> filesToMove = Arrays.asList(this.myElementsToMove);
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        for (PsiElement file : filesToMove) {
            options.overridePackage(file, this.myTargetPackage);
        }
        for (UsageInfo usage : usages) {
            JSReferenceExpression refExpr;
            PsiElement resolved;
            PsiElement element = usage.getElement();
            if (!(element instanceof JSReferenceExpression) || CommonRefactoringUtil.isAncestor((PsiElement)element, filesToMove) || !((resolved = (refExpr = (JSReferenceExpression)element).resolve()) instanceof JSQualifiedNamedElement)) continue;
            PsiElement containingClass = null;
            if ((!(resolved instanceof JSFunction) || !((JSFunction)resolved).isConstructor() || !this.myElements.contains(containingClass = resolved.getParent())) && !this.myElements.contains(resolved)) continue;
            JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)((JSAttributeListOwner)resolved), (JSClass)((JSClass)containingClass), null, (PsiElement)refExpr, (MultiMap)conflicts, (boolean)true, (JSVisibilityUtil.Options)options);
        }
        for (PsiElement fileToMove : filesToMove) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)fileToMove, filesToMove, null, (boolean)true, (MultiMap)conflicts, (Condition)Conditions.alwaysTrue(), (JSVisibilityUtil.Options)options);
        }
        return conflicts;
    }

    protected void retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewMap) {
        super.retargetUsages(usages, oldToNewMap);
        for (UsageInfo usage : usages) {
            JSRefactoringUtil.ConstructorUsageInfo constuctorUsage;
            JSReferenceExpression ref;
            if (!(usage instanceof JSRefactoringUtil.ConstructorUsageInfo) || (ref = (constuctorUsage = (JSRefactoringUtil.ConstructorUsageInfo)usage).getElement()) == null || !constuctorUsage.getSubject().isValid()) continue;
            ref.bindToElement((PsiElement)constuctorUsage.getSubject().getContainingFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveClassProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveClassProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FlexMoveClassUsageViewDescriptor
    extends BaseUsageViewDescriptor {
        public FlexMoveClassUsageViewDescriptor() {
            super(PsiUtilCore.toPsiElementArray((Collection)FlexMoveClassProcessor.this.myElements));
        }

        public String getProcessedElementsHeader() {
            if (this.getElements().length == 1) {
                return FlexBundle.message("element.to.be.moved.to", JSBundle.message((String)JSNamedElementKind.kind((PsiElement)((JSNamedElement)this.getElements()[0])).humanReadableKey(), (Object[])new Object[0]), JSFormatUtil.formatPackage((String)FlexMoveClassProcessor.this.myTargetPackage));
            }
            return FlexBundle.message("elements.to.be.moved.to", JSFormatUtil.formatPackage((String)FlexMoveClassProcessor.this.myTargetPackage));
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            String prefix = this.getElements().length == 1 ? FlexBundle.message("references.in.code.to.0", UsageViewUtil.getLongName((PsiElement)this.getElements()[0])) : RefactoringBundle.message((String)"references.found.in.code");
            return prefix + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
        }
    }
}

